/*
 * Decompiled with CFR 0.152.
 */
package is.hugvit.datapump;

import java.io.PrintWriter;
import java.sql.SQLException;

public class DataException
extends Exception {
    private Exception wrappedException;
    private int position;

    public DataException(String msg) {
        super(msg);
    }

    public DataException(Exception e) {
        super(e.getMessage());
        this.wrappedException = e;
    }

    public DataException(String msg, Exception e) {
        super(msg);
        this.wrappedException = e;
    }

    public DataException(Exception e, int pos) {
        super(e.getMessage());
        this.wrappedException = e;
        this.position = pos;
    }

    public final void setPosition(int pos) {
        this.position = pos;
    }

    @Override
    public final String getMessage() {
        return super.getMessage() + " [pos=" + this.position + "]";
    }

    private static final void printStackTraceEx(Exception e, PrintWriter out) {
        if (out == null) {
            e.printStackTrace();
        } else {
            e.printStackTrace(out);
        }
    }

    private final void printStackTraceEx(PrintWriter out) {
        if (out == null) {
            super.printStackTrace();
        } else {
            super.printStackTrace(out);
        }
        if (this.wrappedException != null) {
            DataException.printStackTraceEx(this.wrappedException, out);
            if (this.wrappedException instanceof SQLException) {
                SQLException s = (SQLException)this.wrappedException;
                for (s = s.getNextException(); s != null; s = s.getNextException()) {
                    DataException.printStackTraceEx(this.wrappedException, out);
                }
            }
        }
    }

    @Override
    public void printStackTrace() {
        this.printStackTraceEx(null);
    }

    @Override
    public void printStackTrace(PrintWriter out) {
        this.printStackTraceEx(out);
    }
}

