/*
 * Decompiled with CFR 0.152.
 */
package is.hugvit.bird.security;

import is.hugvit.bird.BirdEngine;
import is.hugvit.bird.GenericPrincipal;
import is.hugvit.bird.Realm;
import is.hugvit.bird.jaas.security.BirdUserPrincipal;
import is.hugvit.log.Log;
import java.security.Principal;
import javax.annotation.Resource;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebService;
import javax.servlet.ServletContext;
import javax.xml.ws.WebServiceContext;
import javax.xml.ws.handler.MessageContext;

@WebService
public class BirdAuthentication {
    @Resource(type=Object.class)
    protected WebServiceContext wsContext;

    @WebMethod(operationName="authenticate")
    public BirdUserPrincipal authenticate(@WebParam(name="username") String username, @WebParam(name="password") String password) {
        BirdEngine engine = BirdEngine.getInstance();
        Log log = engine.getLog();
        BirdUserPrincipal principal = null;
        MessageContext mc = null;
        ServletContext ctx = null;
        try {
            mc = this.wsContext.getMessageContext();
            ctx = (ServletContext)mc.get((Object)"javax.xml.ws.servlet.context");
        }
        catch (Exception ex) {
            log.error(ex.getMessage());
        }
        Principal curr = this.wsContext.getUserPrincipal();
        if (curr != null) {
            log.error("Pricipal already available: " + curr.getName());
        }
        Realm realm = engine.getRealm();
        Principal p = realm.authenticate(username, password);
        GenericPrincipal gp = null;
        try {
            gp = (GenericPrincipal)p;
        }
        catch (Exception ex) {
            log.error("Realm: " + realm.getInfo() + " must return a valid is.bird.hugvit.GenericPrincipal");
        }
        if (gp != null) {
            principal = new BirdUserPrincipal();
            principal.setName(gp.getName());
            principal.setUserId(gp.getUserId());
            for (String role : gp.getRoles()) {
                principal.getRoles().add(role);
            }
        }
        return principal;
    }
}

