/*
 * Decompiled with CFR 0.152.
 */
package is.hugvit.bird.licence;

import is.hugvit.bird.BirdDatabase;
import is.hugvit.bird.BirdException;
import is.hugvit.bird.BirdFile;
import is.hugvit.bird.Field;
import is.hugvit.bird.Form;
import is.hugvit.bird.WebContext;
import is.hugvit.bird.WebForm;
import is.hugvit.bird.licence.Install;
import is.hugvit.bird.licence.Licence;
import is.hugvit.bird.licence.LicenceService;
import is.hugvit.util.Util;
import java.io.IOException;
import java.io.InputStream;
import org.dom4j.Element;

public class WebLicence
extends WebForm {
    private static final String UPFIELD = "licencefile";

    public WebLicence() {
        this.add(new Field(UPFIELD, 6));
    }

    @Override
    public void doGet(WebContext context) throws BirdException {
        Element elData = context.getRootElement().addElement("info");
        String serverId = LicenceService.getServerId();
        if (serverId != null) {
            elData.addElement("server_id").setText(serverId);
            elData.addElement("version_id").setText(is.hugvit.bird.core.Install.VERSION);
        }
        Licence lic = null;
        try {
            lic = LicenceService.getLicence();
        }
        catch (Exception ex) {
            context.getRootElement().addElement("error").setText(ex.getMessage());
        }
        if (lic != null && lic.isValid()) {
            context.getRootElement().add(lic.getXml());
        }
    }

    @Override
    public void doSave(WebContext context, Form data) throws BirdException {
        try {
            InputStream in = data.getInputStream(UPFIELD);
            if (in != null) {
                boolean results = this.saveLicence(context, in);
                in.close();
                if (results) {
                    data.put("success", "true");
                    data.setMessage(Install.lang.getString("lic.success"));
                }
            }
        }
        catch (IOException ex) {
            throw new BirdException(ex);
        }
    }

    private boolean saveLicence(WebContext ctx, InputStream in) throws BirdException {
        try {
            BirdDatabase db = ctx.getSession().getDatabase();
            BirdFile file = db.getFileByName("__GoProLicenceData");
            if (file == null) {
                file = db.createFile();
            }
            file.setPrivate(true);
            file.setBody(in);
            file.setFilename("__GoProLicenceData.xml");
            file.setName("__GoProLicenceData");
            file.save();
            in.close();
            return true;
        }
        catch (IOException ex) {
            throw new BirdException(ex);
        }
    }

    @Override
    public boolean querySave(WebContext context, Form data) throws BirdException {
        try {
            InputStream in = data.getInputStream(UPFIELD);
            if (in != null) {
                String filename = data.getFilename(UPFIELD);
                if (Util.getFileExt(filename).equals(".gl")) {
                    try {
                        Licence testLic = new Licence(in);
                        return true;
                    }
                    catch (RuntimeException ex) {
                        data.setError(Install.lang.getString("lic.badlic"));
                        return false;
                    }
                    catch (Exception ex) {
                        data.setError(Install.lang.getString("lic.corrupt"));
                        return false;
                    }
                }
                data.setError(Install.lang.getString("lic.invalid"));
                return false;
            }
            data.setError(Install.lang.getString("lic.nofile"));
            return false;
        }
        catch (IOException ex) {
            data.setError(ex.getMessage());
            return false;
        }
    }
}

