/*
 * Decompiled with CFR 0.152.
 */
package is.hugvit.bird.licence;

import is.hugvit.bird.BirdException;
import is.hugvit.bird.licence.LicenceModule;
import is.hugvit.bird.licence.LicenceService;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public final class Licence {
    public static final int NO_USER_LIMIT = -66;
    private Document rootDoc;
    private String customerName;
    private String customerId;
    private String licenceVersion;
    private String serviceProvider;
    private String serverId;
    private String productFamily;
    private String productName;
    private String platform;
    private boolean isValid = false;
    private Set<LicenceModule> modules = new HashSet<LicenceModule>();

    public Licence(InputStream in) throws DocumentException, RuntimeException {
        try {
            try {
                this.serverId = LicenceService.getServerId();
            }
            catch (BirdException ex) {
                throw new RuntimeException("Cannot get valid server ID!");
            }
            SAXReader reader = new SAXReader();
            this.rootDoc = reader.read(in);
            if (this.rootDoc != null) {
                this.initializeFromLicenceFile();
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Licence(InputStream in, String serverId) throws DocumentException, RuntimeException {
        try {
            this.serverId = serverId;
            SAXReader reader = new SAXReader();
            this.rootDoc = reader.read(in);
            if (this.rootDoc != null) {
                this.initializeFromLicenceFile();
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
    }

    public Document getLicenceDoc() {
        return this.rootDoc;
    }

    public final String getCustomerName() {
        return this.customerName;
    }

    public final String getCustomerId() {
        return this.customerId;
    }

    public final boolean isValid() {
        return this.isValid;
    }

    public final String getLicenceVersion() {
        return this.licenceVersion;
    }

    public final String getServiceProvider() {
        return this.serviceProvider;
    }

    public final String getServerId() {
        return this.serverId;
    }

    public final String getProductFamily() {
        return this.productFamily;
    }

    public final String getProductName() {
        return this.productName;
    }

    public final String getPlatform() {
        return this.platform;
    }

    public Set<LicenceModule> getModules() {
        return this.modules;
    }

    public final LicenceModule getLicenceByModuleName(String moduleName) {
        for (LicenceModule lm : this.modules) {
            if (!lm.getName().equalsIgnoreCase(moduleName)) continue;
            return lm;
        }
        return null;
    }

    public Element getXml() {
        Element el = DocumentHelper.createElement((String)"licence");
        if (this.customerName != null) {
            el.addElement("customername").setText(this.customerName);
        }
        if (this.productFamily != null) {
            el.addElement("productfamily").setText(this.productFamily);
        }
        if (this.productName != null) {
            el.addElement("productname").setText(this.productName);
        }
        if (this.serviceProvider != null) {
            el.addElement("provider").setText(this.serviceProvider);
        }
        if (this.modules.size() > 0) {
            Element elMod = el.addElement("modules");
            for (LicenceModule m : this.modules) {
                elMod.add(m.getXml());
            }
        }
        return el;
    }

    private final void initializeFromLicenceFile() {
        if (this.rootDoc != null) {
            Element root = this.rootDoc.getRootElement();
            String licenceServerId = this.getNodeValue((Node)root, "ServerID");
            if (licenceServerId == null || !licenceServerId.equals(this.serverId)) {
                throw new RuntimeException("The serverId for the licence does not match this server!");
            }
            this.customerId = this.getNodeValue((Node)root, "CustomerID");
            this.customerName = this.getNodeValue((Node)root, "CustomerName");
            this.licenceVersion = this.getNodeValue((Node)root, "LicenceVersion");
            this.serviceProvider = this.getNodeValue((Node)root, "ServiceProvider");
            this.productFamily = this.getNodeValue((Node)root, "Products");
            this.productName = this.getNodeValue((Node)root, "Title");
            this.platform = this.getNodeValue((Node)root, "GoProPlatform");
            List modulesNodes = this.rootDoc.getRootElement().selectNodes("gdf:Modules");
            if (modulesNodes != null && modulesNodes.size() > 0) {
                for (Node nm : modulesNodes) {
                    LicenceModule m = new LicenceModule();
                    m.setLicenceKey(this.getNodeValue(nm, "LicenceKey"));
                    m.setName(this.getNodeValue(nm, "Name"));
                    m.setValidFrom(this.getNodeValue(nm, "ValidFrom"));
                    m.setValidTo(this.getNodeValue(nm, "ValidTo"));
                    m.setVersion(this.getNodeValue(nm, "Version"));
                    String userCount = this.getNodeValue(nm, "NumberOfUsers");
                    if (!"".equals(userCount)) {
                        m.setNumberOfUsers(Integer.parseInt(userCount));
                    }
                    m.validateLicence(this.serverId, this.customerId);
                    this.modules.add(m);
                }
            }
            this.isValid = true;
        }
    }

    private final String getNodeValue(Node p, String path) {
        Node n;
        String v = "";
        if (p != null && (n = p.selectSingleNode(path = "gdf:" + path)) != null) {
            v = n.getText();
        }
        return v;
    }
}

