/*
 * Decompiled with CFR 0.152.
 */
package is.hugvit.bird.core;

import is.hugvit.bird.BirdException;
import is.hugvit.bird.WebContext;
import is.hugvit.bird.WebElementBase;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.dom4j.Document;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.XML;

public class WebStatus
extends WebElementBase {
    @Override
    public void doGet(WebContext context) throws BirdException {
        String param = context.getRequest().getParameter("do");
        if ("logout".equals(param)) {
            HttpSession session = context.getRequest().getSession();
            session.invalidate();
            context.setRedirectPage("bird:header");
        }
    }

    @Override
    public void doPost(WebContext context) throws BirdException {
        String postaction = context.getRequest().getParameter("action");
        HttpServletResponse res = context.getResponseExclusive();
        OutputFormat format = OutputFormat.createCompactFormat();
        format.setEncoding("ISO-8859-1");
        format.setSuppressDeclaration(false);
        format.setOmitEncoding(false);
        Document doc = new DocumentFactory().createDocument();
        Element root = doc.addElement("data");
        if (postaction != null) {
            try {
                if ("status".equals(postaction)) {
                    root.addElement("user").setText(context.getRequest().getRemoteUser());
                }
            }
            catch (IllegalArgumentException ex) {
                root.addElement("error").setText(ex.getMessage());
            }
        } else {
            root.addElement("error").setText("Invalid request.");
        }
        try {
            JSONObject json = XML.toJSONObject((String)doc.asXML());
            res.setContentType("application/json; charset=ISO-8859-1");
            BufferedOutputStream out = new BufferedOutputStream((OutputStream)res.getOutputStream());
            out.write(json.toString().getBytes("ISO-8859-1"));
            out.close();
        }
        catch (IOException ex) {
            throw new BirdException(ex);
        }
        catch (JSONException ex) {
            throw new BirdException((Exception)((Object)ex));
        }
    }
}

