/*
 * Decompiled with CFR 0.152.
 */
package is.hugvit.bird.core;

import is.hugvit.bird.BirdException;
import is.hugvit.bird.BirdSession;
import is.hugvit.bird.Form;
import is.hugvit.bird.WebContext;
import is.hugvit.bird.WebForm;
import is.hugvit.bird.core.Install;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public final class WebComponent
extends WebForm {
    @Override
    public final void doSave(WebContext context, Form data) throws BirdException {
        try {
            context.getSession().installComponent(data.getString("classname").trim());
        }
        catch (Exception ex) {
            data.setError("Error installing component: " + ex.getMessage());
            ex.printStackTrace();
            return;
        }
        context.setRedirectPage("bird:componentlist", "s=true");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void doDelete(WebContext context, Form data) throws BirdException {
        try {
            BirdSession session = context.getSession();
            Connection dc = (Connection)context.getAttribute("bird.connection");
            PreparedStatement stmt = dc.prepareStatement("select classname from bird_comp where id=?");
            stmt.setString(1, data.getID());
            ResultSet rd = stmt.executeQuery();
            try {
                if (rd.next()) {
                    String classname = rd.getString(1);
                    session.uninstallComponent(classname);
                    if (classname.equals(Install.class.getName())) {
                        session.installComponent(classname);
                    }
                }
                context.setRedirectPage("bird:componentlist");
            }
            finally {
                rd.close();
                stmt.close();
            }
        }
        catch (Exception e) {
            throw new BirdException(e);
        }
    }
}

