/*
 * Decompiled with CFR 0.152.
 */
package is.hugvit.bird.core;

import is.hugvit.bird.BirdDatabase;
import is.hugvit.bird.BirdException;
import is.hugvit.bird.BirdFile;
import is.hugvit.bird.BirdMenu;
import is.hugvit.bird.BirdPage;
import is.hugvit.bird.WebContext;
import is.hugvit.io.ByteArrayInputStreamEx;
import is.hugvit.io.ByteArrayOutputStreamEx;
import is.hugvit.sql.Null;
import is.hugvit.util.HashMapEx;
import is.hugvit.util.HashtableEx;
import is.hugvit.util.Util;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.ServletContext;
import org.dom4j.Element;

public final class BirdUtil {
    private static final String SQL_WEBROLE_FOLDER_ID = "select folder,webrole from bird_page where type='FOLDER' and id=?";
    private static final String SQL_ROLE_FOLDER_ID = "select folder,role from bird_page where type='FOLDER' and id=?";
    private static final String SQL_UPDATE_PAGE = "update bird_page set webrole=? where type='PAGE' and folder=?";
    private static final String SQL_UPDATE_FILE = "update bird_file set role=? where folder=?";
    private static final String SQL_SELECT_FOLDER = "select id,webrole from bird_page where type='FOLDER' and folder=?";

    private BirdUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void delete(Connection c, String table, String field, String value) throws BirdException {
        try {
            StringBuffer s = new StringBuffer(64);
            s.append("delete from " + table + " where " + field + "=?");
            try (PreparedStatement stmt = c.prepareStatement(s.toString());){
                stmt.setString(1, value);
                stmt.executeUpdate();
            }
        }
        catch (SQLException e) {
            throw new BirdException(e);
        }
    }

    public static final void deletePage(BirdDatabase db, String alias) throws BirdException {
        try (Connection c = db.connect();){
            BirdUtil.delete(c, "bird_page", "alias", alias);
        }
        catch (SQLException e) {
            throw new BirdException(e);
        }
    }

    public static final void deletePageType(BirdDatabase db, String name) throws BirdException {
        try (Connection c = db.connect();){
            BirdUtil.delete(c, "bird_pagetype", "name", name);
        }
        catch (SQLException e) {
            throw new BirdException(e);
        }
    }

    public static final void deleteMenu(BirdDatabase db, String alias) throws BirdException {
        try (Connection c = db.connect();){
            BirdUtil.delete(c, "bird_menu", "alias", alias);
        }
        catch (SQLException e) {
            throw new BirdException(e);
        }
    }

    public static final void deleteElement(BirdDatabase db, String name) throws BirdException {
        try (Connection c = db.connect();){
            BirdUtil.delete(c, "bird_element", "name", name);
        }
        catch (SQLException e) {
            throw new BirdException(e);
        }
    }

    public static final void deleteTemplate(BirdDatabase db, String name) throws BirdException {
        try (Connection c = db.connect();){
            BirdUtil.delete(c, "bird_template", "name", name);
        }
        catch (SQLException e) {
            throw new BirdException(e);
        }
    }

    public static final void deleteFile(BirdDatabase db, String name) throws BirdException {
        try (Connection c = db.connect();){
            BirdUtil.delete(c, "bird_file", "name", name);
        }
        catch (SQLException e) {
            throw new BirdException(e);
        }
    }

    public static final void deleteImages(Object obj, BirdDatabase db) throws BirdException {
        try {
            InputStream in = obj.getClass().getResourceAsStream("images/images.txt");
            if (in != null) {
                BufferedReader r = new BufferedReader(new InputStreamReader(in));
                String name = r.readLine();
                while (name != null) {
                    BirdUtil.deleteFile(db, "bird/" + Util.changeFileExt(name, ""));
                    name = r.readLine();
                }
                r.close();
            }
        }
        catch (IOException e) {
            throw new BirdException(e);
        }
    }

    public static final void insertImages(Object obj, BirdDatabase db) throws BirdException, IOException {
        InputStream in = obj.getClass().getResourceAsStream("images/images.txt");
        BufferedReader r = new BufferedReader(new InputStreamReader(in));
        String name = r.readLine();
        while (name != null) {
            BirdUtil.insertResource(obj, db, "images/", name, null);
            name = r.readLine();
        }
        r.close();
    }

    public static final void insertImage(Object obj, BirdDatabase db, String name, String filename) throws BirdException, IOException {
        BirdFile h = db.createFile();
        h.put("isprivate", "1");
        h.put("name", "bird/" + name);
        h.put("filename", filename);
        h.put("type", "IMAGE");
        InputStream in = obj.getClass().getResourceAsStream("images/" + filename);
        h.put("body", in);
        h.save();
        in.close();
    }

    public static final void insertImageX(Object obj, BirdDatabase db, String filename, String pathname) throws BirdException, IOException {
        InputStream in;
        BirdFile h = db.createFile();
        h.put("isprivate", "1");
        h.put("filename", filename);
        h.put("type", "IMAGE");
        if (pathname == null || pathname.length() == 0) {
            h.put("name", "bird/gas");
            in = obj.getClass().getResourceAsStream("images/gas/" + filename);
        } else {
            h.put("name", pathname);
            in = obj.getClass().getResourceAsStream("images/" + filename);
        }
        h.put("body", in);
        h.save();
        in.close();
    }

    public static final void insertFile(Object obj, BirdDatabase db, String filename) throws BirdException, IOException {
        BirdUtil.insertResource(obj, db, "files/", filename, null);
    }

    public static final void insertFile(Object obj, BirdDatabase db, String filename, String pathname) throws BirdException, IOException {
        BirdUtil.insertResource(obj, db, "files/", filename, pathname);
    }

    public static final void insertFile(Object obj, BirdDatabase db, String filename, String pathname, String localpath) throws BirdException, IOException {
        if (localpath == null) {
            BirdUtil.insertResource(obj, db, "files/", filename, pathname);
        } else {
            BirdUtil.insertResource(obj, db, "files/" + localpath, filename, pathname);
        }
    }

    private static final void insertResource(Object obj, BirdDatabase db, String path, String filename, String pathname) throws BirdException, IOException {
        try {
            BirdFile h = db.createFile();
            h.put("isprivate", "1");
            int i = filename.indexOf(46);
            String name = filename.substring(0, i);
            if (pathname == null || pathname.length() == 0) {
                h.put("name", "bird/" + name);
            } else {
                h.put("name", pathname);
            }
            h.put("filename", filename);
            InputStream in = obj.getClass().getResourceAsStream(path + filename);
            String mime = null;
            ServletContext context = db.getSession().getServletContext();
            if (context != null) {
                mime = context.getMimeType(filename.toLowerCase());
            }
            if (mime != null) {
                if (mime.startsWith("image/")) {
                    h.put("type", "IMAGE");
                } else {
                    h.put("type", "CODE");
                    h.put("encoding", "ISO-8859-1");
                }
            }
            h.put("body", in);
            h.save();
            in.close();
        }
        catch (NullPointerException ex) {
            throw new BirdException("Error inserting file: " + filename, ex);
        }
    }

    private static final void setStatementValues(PreparedStatement stmt, Hashtable h, int start) throws SQLException, IOException {
        if (h == null) {
            return;
        }
        Enumeration e = h.keys();
        int i = start;
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            Object o = h.get(name);
            if (o == null) {
                stmt.setObject(i, null);
            } else if (o instanceof Null) {
                int type = ((Null)o).getType();
                stmt.setNull(i, type);
            } else if (o instanceof Integer) {
                stmt.setInt(i, (Integer)o);
            } else if (o instanceof ByteArrayInputStreamEx) {
                ByteArrayInputStreamEx inx = (ByteArrayInputStreamEx)o;
                stmt.setBinaryStream(i, (InputStream)inx, inx.size());
            } else if (o instanceof InputStream) {
                InputStream in = (InputStream)o;
                ByteArrayOutputStreamEx out = new ByteArrayOutputStreamEx(4096);
                Util.writeStream(in, out);
                ByteArrayInputStreamEx inx = new ByteArrayInputStreamEx(out);
                stmt.setBinaryStream(i, (InputStream)inx, inx.size());
            } else if (o instanceof Time) {
                stmt.setTime(i, (Time)o);
            } else if (o instanceof Timestamp) {
                stmt.setTimestamp(i, (Timestamp)o);
            } else if (o instanceof java.util.Date) {
                java.util.Date d = (java.util.Date)o;
                stmt.setDate(i, new Date(d.getTime()));
            } else if (o instanceof Boolean) {
                Boolean b = (Boolean)o;
                String v = b != false ? "1" : "0";
                stmt.setString(i, v);
            } else if (o instanceof Vector) {
                String s = Util.expand((Vector)o, ";");
                stmt.setString(i, s);
            } else {
                stmt.setString(i, o.toString());
            }
            ++i;
        }
    }

    public static final void appendWhere(StringBuffer s, Hashtable fields) throws SQLException {
        if (fields == null) {
            return;
        }
        if (fields.size() > 0) {
            s.append(" where ");
            Enumeration e = fields.keys();
            int i = 0;
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                if (i > 0) {
                    s.append(" AND ");
                }
                s.append(name + "=?");
                ++i;
            }
        }
    }

    private static final void cleanFields(Hashtable h) {
        h.remove("pageclasses");
        Vector<String> v = new Vector<String>();
        Enumeration<Object> e = h.keys();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            if (!name.startsWith("_")) continue;
            v.addElement(name);
        }
        e = v.elements();
        while (e.hasMoreElements()) {
            h.remove(e.nextElement());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void insert(Connection c, String name, Hashtable h) throws BirdException {
        try {
            StringBuffer s = new StringBuffer(128);
            StringBuffer t = new StringBuffer(64);
            s.append("insert into " + name + " (");
            BirdUtil.cleanFields(h);
            Enumeration e = h.keys();
            int i = 0;
            while (e.hasMoreElements()) {
                String n = (String)e.nextElement();
                if (i > 0) {
                    s.append(",");
                    t.append(",");
                }
                s.append(n);
                t.append("?");
                ++i;
            }
            s.append(") VALUES (");
            s.append(t.toString());
            s.append(")");
            try (PreparedStatement stmt = c.prepareStatement(s.toString());){
                BirdUtil.setStatementValues(stmt, h, 1);
                stmt.executeUpdate();
            }
        }
        catch (SQLException e) {
            throw new BirdException(e);
        }
        catch (IOException e) {
            throw new BirdException(e);
        }
    }

    public static final void delete(Connection c, String name, String id) throws BirdException {
        try {
            StringBuffer s = new StringBuffer(128);
            s.append("delete from " + name + " where id=?");
            PreparedStatement stmt = c.prepareStatement(s.toString());
            Hashtable<String, String> key = new Hashtable<String, String>();
            key.put("id", id);
            BirdUtil.setStatementValues(stmt, key, 1);
            stmt.executeUpdate();
            stmt.close();
        }
        catch (Exception e) {
            throw new BirdException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void update(Connection c, String name, Hashtable h, Hashtable key) throws BirdException {
        try {
            StringBuffer s = new StringBuffer(64);
            s.append("update " + name + " set ");
            BirdUtil.cleanFields(h);
            Enumeration e = h.keys();
            int i = 0;
            while (e.hasMoreElements()) {
                String n = (String)e.nextElement();
                if (i > 0) {
                    s.append(",");
                }
                s.append(n);
                s.append("=?");
                ++i;
            }
            BirdUtil.appendWhere(s, key);
            try (PreparedStatement stmt = c.prepareStatement(s.toString());){
                BirdUtil.setStatementValues(stmt, h, 1);
                BirdUtil.setStatementValues(stmt, key, h.size() + 1);
                stmt.executeUpdate();
            }
        }
        catch (SQLException e) {
            throw new BirdException(e);
        }
        catch (IOException e) {
            throw new BirdException(e);
        }
    }

    public static final void insertMenu(BirdDatabase db, String role, String name, String alias, String url, String icon) throws BirdException {
        BirdMenu h = db.createMenu();
        h.put("name", name);
        h.put("alias", alias);
        h.put("url", url);
        h.put("role", role);
        h.put("icon", icon);
        h.save();
    }

    public static final void view_generateXML(WebContext context, String fields, String table, Hashtable key) throws BirdException {
        BirdUtil.view_generateXML(context, fields, table, key, null);
    }

    public static final void view_generateXML(WebContext context, String fields, String table) throws BirdException {
        BirdUtil.view_generateXML(context, fields, table, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void view_generateXML(WebContext context, String fields, String table, Hashtable key, String order) throws BirdException {
        try {
            Connection dc = (Connection)context.getAttribute("bird.connection");
            Element root = context.getRootElement().addElement("bird_view");
            String t = table.toLowerCase();
            StringBuffer s = new StringBuffer("select " + fields + " from " + table);
            BirdUtil.appendWhere(s, key);
            if (order != null) {
                s.append(" order by " + order);
            }
            PreparedStatement stmt = dc.prepareStatement(s.toString());
            BirdUtil.setStatementValues(stmt, key, 1);
            ResultSet rd = stmt.executeQuery();
            table = table.toLowerCase();
            try {
                block6: while (rd.next()) {
                    int i = 0;
                    Element item = null;
                    StringTokenizer e = new StringTokenizer(fields, ",");
                    while (e.hasMoreElements()) {
                        String v;
                        Object obj;
                        ++i;
                        String n = (String)e.nextElement();
                        if (n.equals("isprivate")) {
                            String isprivate = rd.getString(i);
                            if (isprivate == null || !isprivate.equals("1") || context.isUserInRole("super_administrator")) continue;
                            continue block6;
                        }
                        if (n.equals("role")) {
                            String[] roles = Util.splitArray(rd.getString(i), ";");
                            if (context.isUserInAllRoles(roles)) continue;
                            continue block6;
                        }
                        if (item == null) {
                            item = root.addElement(t);
                        }
                        if ((obj = rd.getObject(i)) instanceof java.util.Date) {
                            java.util.Date d = (java.util.Date)obj;
                            obj = Util.dateTimeToShort(d);
                        }
                        if (obj == null || (v = obj.toString()).equals("")) continue;
                        item.addElement(n).addText(v);
                    }
                }
            }
            finally {
                rd.close();
                stmt.close();
            }
        }
        catch (SQLException e) {
            throw new BirdException(e);
        }
        catch (IOException e) {
            throw new BirdException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final HashMapEx getAllWebRolesForFolder(Connection c, String id) throws SQLException {
        HashMapEx roles = new HashMapEx();
        try (PreparedStatement stmt = c.prepareStatement(SQL_WEBROLE_FOLDER_ID);){
            while (true) {
                stmt.setString(1, id);
                ResultSet rs = stmt.executeQuery();
                try {
                    if (rs.next()) {
                        id = rs.getString(1);
                        String r = rs.getString(2);
                        if (r != null && !r.equals("")) {
                            StringTokenizer st = new StringTokenizer(r, ";");
                            while (st.hasMoreTokens()) {
                                roles.put(st.nextToken(), null);
                            }
                        }
                        if (id != null && !id.equals("")) continue;
                    }
                }
                finally {
                    rs.close();
                    continue;
                }
                break;
            }
        }
        return roles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final HashMapEx getAllRolesForFolder(Connection c, String id) throws SQLException {
        HashMapEx roles = new HashMapEx();
        try (PreparedStatement stmt = c.prepareStatement(SQL_ROLE_FOLDER_ID);){
            while (true) {
                stmt.setString(1, id);
                ResultSet rs = stmt.executeQuery();
                try {
                    if (rs.next()) {
                        id = rs.getString(1);
                        String r = rs.getString(2);
                        if (r != null && !r.equals("")) {
                            StringTokenizer st = new StringTokenizer(r, ";");
                            while (st.hasMoreTokens()) {
                                roles.put(st.nextToken(), null);
                            }
                        }
                        if (id != null && !id.equals("")) continue;
                    }
                }
                finally {
                    rs.close();
                    continue;
                }
                break;
            }
        }
        return roles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void updatePageRoles(Connection c, String id, HashMapEx roles) throws SQLException {
        Object roles2;
        try (PreparedStatement stmt = c.prepareStatement(SQL_UPDATE_PAGE);){
            stmt.setString(1, roles.toString(';'));
            stmt.setString(2, id);
            stmt.executeUpdate();
        }
        HashMapEx folders = new HashMapEx();
        stmt = c.prepareStatement(SQL_SELECT_FOLDER);
        try {
            stmt.setString(1, id);
            try (ResultSet rs = stmt.executeQuery();){
                while (rs.next()) {
                    String id2 = rs.getString(1);
                    roles2 = rs.getString(2);
                    HashMapEx h = new HashMapEx((Map)roles);
                    if (roles2 != null && !((String)roles2).equals("")) {
                        StringTokenizer st = new StringTokenizer((String)roles2, ";");
                        while (st.hasMoreTokens()) {
                            h.put(st.nextToken(), null);
                        }
                    }
                    folders.put(id2, h);
                }
            }
        }
        finally {
            stmt.close();
        }
        for (String id2 : folders.keySet()) {
            roles2 = (HashMapEx)folders.get(id2);
            BirdUtil.updatePageRoles(c, id2, (HashMapEx)roles2);
        }
    }

    public static final void updateRole(Connection c, String name, HashtableEx h) throws SQLException {
        String folder = (String)h.get("folder");
        if (folder == null || folder.equals("")) {
            h.put(name, "");
        } else {
            HashMapEx m = BirdUtil.getAllWebRolesForFolder(c, folder);
            h.put(name, m.toString(';'));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void updateFileRoles(Connection c, String id, HashMapEx roles) throws SQLException {
        Object roles2;
        try (PreparedStatement stmt = c.prepareStatement(SQL_UPDATE_FILE);){
            stmt.setString(1, roles.toString(';'));
            stmt.setString(2, id);
            stmt.executeUpdate();
        }
        HashMapEx folders = new HashMapEx();
        stmt = c.prepareStatement(SQL_SELECT_FOLDER);
        try {
            stmt.setString(1, id);
            try (ResultSet rs = stmt.executeQuery();){
                while (rs.next()) {
                    String id2 = rs.getString(1);
                    roles2 = rs.getString(2);
                    HashMapEx h = new HashMapEx((Map)roles);
                    if (roles2 != null && !((String)roles2).equals("")) {
                        StringTokenizer st = new StringTokenizer((String)roles2, ";");
                        while (st.hasMoreTokens()) {
                            h.put(st.nextToken(), null);
                        }
                    }
                    folders.put(id2, h);
                }
            }
        }
        finally {
            stmt.close();
        }
        for (String id2 : folders.keySet()) {
            roles2 = (HashMapEx)folders.get(id2);
            BirdUtil.updateFileRoles(c, id2, (HashMapEx)roles2);
        }
    }

    public static final boolean checkPageRole(WebContext context, String id) throws BirdException {
        if (!id.equals("")) {
            BirdDatabase db = context.getSession().getDatabase();
            BirdPage pagex = db.getPageByID(id);
            List role = pagex.getAllRoles();
            for (String r : role) {
                if (context.isUserInRole(r)) continue;
                context.setStatusUnAuthorized();
                return false;
            }
        }
        return true;
    }
}

