/*
 * Decompiled with CFR 0.152.
 */
package is.hugvit.bird.core;

import is.hugvit.bird.BirdDatabase;
import is.hugvit.bird.BirdElement;
import is.hugvit.bird.BirdException;
import is.hugvit.bird.BirdMenu;
import is.hugvit.bird.BirdPage;
import is.hugvit.bird.BirdSession;
import is.hugvit.bird.core.BirdUtil;
import is.hugvit.sql.NativeTypes;
import is.hugvit.util.UID;
import is.hugvit.util.Util;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;

public class BirdInstallHelper {
    private Document idoc = null;
    private ResourceBundle lang;
    private Object caller = null;
    private Procedure procedure = Procedure.Full;

    public BirdInstallHelper(Document doc, ResourceBundle rb, Object cls) {
        this.idoc = doc;
        this.lang = rb;
        this.caller = cls;
    }

    public Procedure getProcedure() {
        return this.procedure;
    }

    public void Install(BirdSession context, BirdDatabase db) throws BirdException {
        this.checkProcedure(context);
        if (Procedure.Partial.equals((Object)this.procedure)) {
            context.getLog().info("Partial Install, only upgrading Bird Pages, Element, Menus and Files");
            this.createPages(context);
            this.createElements(context);
            this.createFiles(context);
            this.createMenus(context);
        } else {
            boolean isDDL = this.createTablesFromSchema(context);
            if (!isDDL) {
                this.createTables(context);
            }
            this.executeStatements(context);
            this.createPages(context);
            this.createElements(context);
            this.createFiles(context);
            this.createMenus(context);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void Uninstall(BirdSession context, BirdDatabase db, boolean droptables) throws BirdException {
        this.checkProcedure(context);
        if (Procedure.Partial.equals((Object)this.procedure)) {
            context.getLog().info("Partial uninstall, only uninstalling Bird Pages, Element, Menus and Files");
            List list = this.idoc.selectNodes("//menus/menu");
            for (Node node : list) {
                BirdUtil.deleteMenu(db, node.valueOf("@alias"));
            }
            list = this.idoc.selectNodes("//elements/element");
            for (Node node : list) {
                BirdUtil.deleteElement(db, node.selectSingleNode("name").getText());
            }
            list = this.idoc.selectNodes("//pages/page");
            for (Node node : list) {
                BirdUtil.deletePage(db, node.selectSingleNode("alias").getText());
            }
            list = this.idoc.selectNodes("//files/file", ".");
            for (Node node : list) {
                String filename = node.valueOf("@name");
                String birdFileName = "bird/" + Util.changeFileExt(filename, "");
                BirdUtil.deleteFile(db, birdFileName);
            }
            return;
        } else {
            List list = this.idoc.selectNodes("//menus/menu");
            for (Node node : list) {
                BirdUtil.deleteMenu(db, node.valueOf("@alias"));
            }
            list = this.idoc.selectNodes("//elements/element");
            for (Node node : list) {
                BirdUtil.deleteElement(db, node.selectSingleNode("name").getText());
            }
            list = this.idoc.selectNodes("//pages/page");
            for (Node node : list) {
                BirdUtil.deletePage(db, node.selectSingleNode("alias").getText());
            }
            list = this.idoc.selectNodes("//files/file", ".");
            for (Node node : list) {
                String filename = node.valueOf("@name");
                String birdFileName = "bird/" + Util.changeFileExt(filename, "");
                BirdUtil.deleteFile(db, birdFileName);
            }
            try {
                if (!droptables) return;
                list = this.idoc.selectNodes("//tables/table");
                Iterator it = list.iterator();
                Connection conn = db.connect();
                Statement stmt = conn.createStatement();
                while (it.hasNext()) {
                    Node node = (Node)it.next();
                    String tablename = node.valueOf("@name").toLowerCase();
                    stmt.executeUpdate("DROP TABLE " + tablename);
                }
                stmt.close();
                return;
            }
            catch (SQLException ex) {
                throw new BirdException(ex);
            }
        }
    }

    private final void createMenus(BirdSession context) throws BirdException {
        String mpf;
        BirdDatabase db = context.getDatabase();
        List menus = this.idoc.selectNodes("//menus/menu", "order");
        if (menus.size() == 0) {
            return;
        }
        Iterator it = menus.iterator();
        String menuPrefix = this.idoc.selectSingleNode("//menus").valueOf("@prefix");
        if (this.lang.containsKey("menu.prefix") && (mpf = this.lang.getString("menu.prefix")) != null && !"".equals(mpf)) {
            menuPrefix = mpf;
        }
        boolean autoIndex = true;
        try {
            String autoIdx = this.idoc.selectSingleNode("//menus").valueOf("@autoindex");
            if (autoIdx != null && autoIdx.equalsIgnoreCase("false")) {
                autoIndex = false;
            }
        }
        catch (Exception autoIdx) {
            // empty catch block
        }
        int menuIndex = 1;
        while (it.hasNext()) {
            Node node = (Node)it.next();
            BirdMenu h = db.createMenu();
            h.put("url", node.valueOf("@url"));
            h.put("alias", node.valueOf("@alias"));
            h.put("role", node.valueOf("@role"));
            Node n = node.selectSingleNode("translatekey");
            String translated = this.lang.getString(n.getText());
            String name = autoIndex ? menuPrefix + "\\" + menuIndex + ". " + translated : menuPrefix + "\\" + translated;
            h.put("name", name);
            h.save();
            ++menuIndex;
        }
    }

    private final void createElements(BirdSession context) throws BirdException {
        BirdDatabase db = context.getDatabase();
        List pages = this.idoc.selectNodes("//elements/element", ".");
        for (Element el : pages) {
            List nodes = el.elements();
            Iterator itNodes = nodes.iterator();
            BirdElement h = db.createElement();
            while (itNodes.hasNext()) {
                Node node = (Node)itNodes.next();
                String key = node.getName();
                String val = node.getText();
                h.put(key, val);
            }
            h.save();
        }
    }

    private final void createPages(BirdSession context) throws BirdException {
        try {
            BirdDatabase db = context.getDatabase();
            List pages = this.idoc.selectNodes("//pages/page", ".");
            for (Element el : pages) {
                List nodes = el.elements();
                Iterator itNodes = nodes.iterator();
                BirdPage h = db.createPage();
                while (itNodes.hasNext()) {
                    Node node = (Node)itNodes.next();
                    String key = node.getName();
                    Object val = node.getText();
                    if ("elements".equals(key)) {
                        val = Util.split((String)val, ",");
                    }
                    if ("body".equals(key)) {
                        val = Util.getResourceString(this.caller, (String)val);
                    }
                    h.put(key, val);
                }
                h.save();
            }
        }
        catch (IOException ex) {
            throw new BirdException(ex);
        }
    }

    private final void createFiles(BirdSession context) throws BirdException {
        try {
            BirdDatabase db = context.getDatabase();
            List files = this.idoc.selectNodes("//files/file", ".");
            for (Node node : files) {
                String type = node.valueOf("@type");
                String filename = node.valueOf("@name");
                if (type.equals("image")) {
                    String name = filename.substring(0, filename.lastIndexOf(46));
                    BirdUtil.insertImage(this.caller, db, name, filename);
                    continue;
                }
                BirdUtil.insertFile(this.caller, db, filename);
            }
        }
        catch (IOException ex) {
            throw new BirdException(ex);
        }
    }

    private final void executeStatements(BirdSession context) throws BirdException {
        int stamps;
        boolean commit;
        String query;
        Node node;
        List queries = this.idoc.selectNodes("//querys/query", "@order");
        Iterator it = queries.iterator();
        Timestamp ts = new Timestamp(new Date().getTime());
        String now = ts.toString();
        while (it.hasNext()) {
            node = (Node)it.next();
            query = node.getText().replace("@GEN", "'" + UID.getUID() + "'");
            commit = "true".equalsIgnoreCase(node.valueOf("@commit"));
            stamps = StringUtils.countMatches((String)query, (String)"@NOW");
            if (stamps > 0) {
                query = query.replace("@NOW", "?");
                this.executeTimestampStatement(context, query, stamps, commit);
                continue;
            }
            this.executeStatement(context, query, commit);
        }
        queries = this.idoc.selectNodes("//updatequeries/query", "@order");
        it = queries.iterator();
        ts = new Timestamp(new Date().getTime());
        now = ts.toString();
        while (it.hasNext()) {
            node = (Node)it.next();
            query = node.getText().replace("@GEN", "'" + UID.getUID() + "'");
            commit = "true".equalsIgnoreCase(node.valueOf("@commit"));
            stamps = StringUtils.countMatches((String)query, (String)"@NOW");
            if (stamps > 0) {
                query = query.replace("@NOW", "?");
                this.executeTimestampStatement(context, query, stamps, commit);
                continue;
            }
            this.executeStatement(context, query, commit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void executeTimestampStatement(BirdSession context, String sql, int count, boolean commit) throws BirdException {
        BirdDatabase db = context.getDatabase();
        Connection c = db.connect();
        try {
            if (commit) {
                c.setAutoCommit(false);
            }
            PreparedStatement s = c.prepareStatement(sql);
            for (int i = 1; i <= count; ++i) {
                s.setTimestamp(i, new Timestamp(new Date().getTime()));
            }
            s.executeUpdate();
            if (commit) {
                c.commit();
                c.setAutoCommit(true);
            }
            s.close();
        }
        catch (SQLException ex) {
            context.getLog().error("Execute statement Error: " + ex.getMessage() + " (" + sql + ")");
        }
        finally {
            try {
                c.close();
            }
            catch (SQLException e) {
                throw new BirdException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void executeStatement(BirdSession context, String sql, boolean commit) throws BirdException {
        BirdDatabase db = context.getDatabase();
        Connection c = db.connect();
        try {
            if (commit) {
                c.setAutoCommit(false);
            }
            Statement s = c.createStatement();
            s.executeUpdate(sql);
            if (commit) {
                c.commit();
                c.setAutoCommit(true);
            }
            s.close();
        }
        catch (SQLException ex) {
            context.getLog().error("Execute statement Error: " + ex.getMessage() + " (" + sql + ")");
        }
        finally {
            try {
                c.close();
            }
            catch (SQLException e) {
                throw new BirdException(e);
            }
        }
    }

    private final boolean createTablesFromSchema(BirdSession context) throws BirdException {
        Connection dc = null;
        try {
            BirdDatabase db = context.getDatabase();
            dc = db.connect();
            String sqlServerType = dc.getMetaData().getDatabaseProductName();
            int sqlServerVersion = dc.getMetaData().getDatabaseMajorVersion();
            List schemas = this.idoc.selectNodes("//schemas/schema");
            Node schemaNode = null;
            for (Node schema : schemas) {
                String identity = schema.valueOf("@identifier").toLowerCase();
                int minVersion = Integer.valueOf(schema.valueOf("@minversion"));
                if (identity == null || !sqlServerType.toLowerCase().contains(identity) || sqlServerVersion < minVersion) continue;
                schemaNode = schema;
                break;
            }
            if (schemaNode != null) {
                context.getLog().info("Creating tables using DDL for " + sqlServerType);
                String sqlFile = schemaNode.valueOf("@file");
                String filepath = context.getServletContext().getRealPath("/") + sqlFile;
                File file = new File(context.getServletContext().getRealPath("/"), sqlFile);
                if (file != null) {
                    try {
                        this.createSchema(dc, file);
                    }
                    catch (SQLException ex) {
                        context.getLog().error("Error running SQL script: " + ex.getMessage());
                        boolean bl = false;
                        try {
                            dc.close();
                        }
                        catch (SQLException ex2) {
                            throw new BirdException(ex2);
                        }
                        return bl;
                    }
                    boolean bl = true;
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception ex) {
            throw new BirdException(ex);
        }
        finally {
            try {
                dc.close();
            }
            catch (SQLException ex) {
                throw new BirdException(ex);
            }
        }
    }

    private final void createSchema(Connection c, File schemaFile) throws SQLException, BirdException {
        String s = new String();
        StringBuffer sb = new StringBuffer();
        try (Statement st = null;){
            FileReader fr = new FileReader(schemaFile);
            BufferedReader br = new BufferedReader(fr);
            while ((s = br.readLine()) != null) {
                if (s.length() > 0 && s.charAt(0) == '-' || s.length() == 0) continue;
                sb.append(s);
            }
            br.close();
            String[] inst = sb.toString().split(";");
            st = c.createStatement();
            for (int i = 0; i < inst.length; ++i) {
                if (inst[i].trim().equals("")) continue;
                st.executeUpdate(inst[i]);
            }
        }
    }

    private final void createTables(BirdSession context) throws BirdException {
        Connection dc = null;
        try {
            BirdDatabase db = context.getDatabase();
            dc = db.connect();
            NativeTypes nt = new NativeTypes(dc);
            Vector<String[]> primaryKeys = new Vector<String[]>();
            Vector<String[]> uniqueKeys = new Vector<String[]>();
            Vector foreignKeys = new Vector();
            List tables = this.idoc.selectNodes("//tables/table", "@order");
            Iterator it = tables.iterator();
            while (it.hasNext()) {
                Hashtable<String, String> h = new Hashtable<String, String>();
                Hashtable<String, String> h_native = new Hashtable<String, String>();
                Hashtable<String, String> unique = new Hashtable<String, String>();
                Node node = (Node)it.next();
                String tableName = node.valueOf("@name").toLowerCase();
                List cols = node.selectNodes("col");
                for (Node col : cols) {
                    boolean isUnique;
                    String colType;
                    String colName = col.valueOf("@name").toLowerCase();
                    String colTypeNative = colType = col.valueOf("@type");
                    boolean isNull = col.valueOf("@null").equals("true");
                    boolean isPrimary = col.valueOf("@primary").length() > 0;
                    boolean isForeign = col.valueOf("@foreign").length() > 0;
                    boolean bl = isUnique = col.valueOf("@unique").length() > 0;
                    if (isPrimary) {
                        String[] s = new String[]{tableName, colName, col.valueOf("@primary")};
                        primaryKeys.add(s);
                    }
                    if (isForeign) {
                        ArrayList<String> l = new ArrayList<String>();
                        l.add(tableName);
                        l.add(colName);
                        l.addAll(Util.split(col.valueOf("@foreign"), "."));
                        foreignKeys.add(l);
                    }
                    if (isUnique) {
                        String uKey = col.valueOf("@unique");
                        Vector uKeys = Util.split(uKey, ",");
                        Enumeration eKeys = uKeys.elements();
                        while (eKeys.hasMoreElements()) {
                            String currKey = (String)eKeys.nextElement();
                            if (!unique.containsKey(currKey)) {
                                unique.put(currKey, colName);
                                continue;
                            }
                            String oldKey = (String)unique.get(currKey);
                            String newKey = oldKey + ", " + colName;
                            unique.remove(currKey);
                            unique.put(currKey, newKey);
                        }
                    }
                    if (!colType.toLowerCase().startsWith("char") && !colType.toLowerCase().startsWith("varchar")) {
                        colTypeNative = colType.toLowerCase().startsWith("blob") ? nt.getString("BLOB") : nt.getString(colType);
                    }
                    if (!isNull) {
                        colType = colType + " NOT NULL";
                        colTypeNative = colTypeNative + " NOT NULL";
                    }
                    h.put(colName, colType);
                    h_native.put(colName, colTypeNative);
                }
                Enumeration e = unique.keys();
                while (e.hasMoreElements()) {
                    String n = (String)e.nextElement();
                    String c = (String)unique.get(n);
                    String[] s = new String[]{tableName, c, n};
                    uniqueKeys.add(s);
                }
                if (db.tableExists(tableName)) continue;
                try {
                    db.createTable(tableName, h);
                }
                catch (BirdException ex) {
                    context.getLog().warn("Error creating table: " + ex.getMessage());
                    context.getLog().warn("Re-trying with native data type ..");
                    db.createTable(tableName, h_native);
                    context.getLog().info("Successfully created table in second attempt.");
                }
            }
            for (String[] s : primaryKeys) {
                try {
                    db.alterTableSetPrimary(s[0], s[1], s[2]);
                }
                catch (Exception ex) {
                    context.getLog().warn("Could not create Primary key: " + s[2]);
                }
            }
            for (String[] s : uniqueKeys) {
                try {
                    db.alterTableSetUnique(s[0], s[1], s[2]);
                }
                catch (Exception exception) {
                    context.getLog().warn("Could not create Unique key: " + s[2]);
                }
            }
            for (ArrayList arrayList : foreignKeys) {
                try {
                    db.alterTableSetForeignKey((String)arrayList.get(0), (String)arrayList.get(1), (String)arrayList.get(2), (String)arrayList.get(3), (String)arrayList.get(4));
                }
                catch (Exception ex) {
                    context.getLog().warn("Could not create Foreign key: " + (String)arrayList.get(2));
                }
            }
        }
        catch (Exception ex) {
            throw new BirdException(ex);
        }
        finally {
            try {
                dc.close();
            }
            catch (SQLException ex) {
                throw new BirdException(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkProcedure(BirdSession context) {
        InputStream in = null;
        Properties p = new Properties();
        try {
            String proc;
            in = context.getServletContext().getResourceAsStream("/WEB-INF/bird_config.properties");
            p.load(in);
            if (p.containsKey("procedure") && (proc = p.getProperty("procedure")).equalsIgnoreCase("upgrade")) {
                this.procedure = Procedure.Partial;
            }
        }
        catch (Exception ex) {
            context.getLog().error(ex);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ex) {
                    context.getLog().warn("Error closing stream", ex);
                }
            }
        }
    }

    public static enum Procedure {
        Full,
        Partial;

    }
}

