/*
 * Decompiled with CFR 0.152.
 */
package is.hugvit.bird;

import is.hugvit.bird.BirdException;
import is.hugvit.bird.WebContext;
import is.hugvit.bird.WebElementBase;
import is.hugvit.util.Util;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import javax.servlet.http.HttpServletRequest;
import org.dom4j.Element;

public final class WebSearch
extends WebElementBase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void doPost(WebContext context) throws BirdException {
        Element root = context.getRootElement();
        HttpServletRequest req = context.getRequest();
        String search = req.getParameter("search");
        int max = context.getParameterInt("max");
        String order = context.getParameter("order");
        if (search == null || search.equals("")) {
            return;
        }
        Connection c = (Connection)context.getAttribute("bird.connection");
        StringBuffer s = new StringBuffer("select title,name,pagedate,description from bird_page where type='PAGE' and visible='1' and not (name like 'admin/%') and (textbody like ? or title like ? or description like ?)");
        if (order != null) {
            s.append(" order by " + order);
        }
        try (PreparedStatement stmt = c.prepareStatement(s.toString());){
            stmt.setMaxRows(max);
            search = '%' + search + '%';
            stmt.setString(1, search);
            stmt.setString(2, search);
            stmt.setString(3, search);
            Element r = root.addElement("bird_search");
            r.addAttribute("search", search);
            try (ResultSet rs = stmt.executeQuery();){
                DateFormat df = DateFormat.getDateInstance(3);
                String dateformat = context.getParameter("dateformat");
                if (dateformat != null) {
                    df = new SimpleDateFormat(dateformat);
                }
                while (rs.next()) {
                    Element item = r.addElement("page");
                    item.addElement("title").addText(rs.getString(1));
                    item.addElement("name").addText(rs.getString(2));
                    Date d = rs.getDate(3);
                    Element date = item.addElement("date");
                    date.addText(Util.dateToISO(d));
                    date.addAttribute("text", df.format(d));
                    String desc = rs.getString(4);
                    if (desc == null) continue;
                    item.addElement("description").addText(desc);
                }
            }
        }
        catch (SQLException e) {
            throw new BirdException(e);
        }
    }
}

