/*
 * Decompiled with CFR 0.152.
 */
package is.hugvit.bird;

import is.hugvit.bird.BirdException;
import is.hugvit.bird.Form;
import is.hugvit.bird.WebContext;
import is.hugvit.bird.WebForm;
import is.hugvit.io.ByteArrayInputStreamEx;
import is.hugvit.io.ByteArrayOutputStreamEx;
import is.hugvit.sql.Null;
import is.hugvit.util.UID;
import is.hugvit.util.Util;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class WebSQLForm
extends WebForm {
    private static final void setStatementValues(PreparedStatement stmt, Hashtable h, int start) throws SQLException, IOException {
        if (h == null) {
            return;
        }
        Enumeration e = h.keys();
        int i = start;
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            Object o = h.get(name);
            if (o == null) {
                stmt.setObject(i, null);
            } else if (o instanceof Null) {
                int type = ((Null)o).getType();
                stmt.setNull(i, type);
            } else if (o instanceof Integer) {
                stmt.setInt(i, (Integer)o);
            } else if (o instanceof ByteArrayInputStreamEx) {
                ByteArrayInputStreamEx inx = (ByteArrayInputStreamEx)o;
                stmt.setBinaryStream(i, (InputStream)inx, inx.size());
            } else if (o instanceof InputStream) {
                InputStream in = (InputStream)o;
                ByteArrayOutputStreamEx out = new ByteArrayOutputStreamEx(4096);
                Util.writeStream(in, out);
                ByteArrayInputStreamEx inx = new ByteArrayInputStreamEx(out);
                stmt.setBinaryStream(i, (InputStream)inx, inx.size());
            } else if (o instanceof Time) {
                stmt.setTime(i, (Time)o);
            } else if (o instanceof Timestamp) {
                stmt.setTimestamp(i, (Timestamp)o);
            } else if (o instanceof java.util.Date) {
                java.util.Date d = (java.util.Date)o;
                stmt.setDate(i, new Date(d.getTime()));
            } else if (o instanceof Boolean) {
                Boolean b = (Boolean)o;
                String v = b != false ? "1" : "0";
                stmt.setString(i, v);
            } else if (o instanceof Vector) {
                String s = Util.expand((Vector)o, ";");
                stmt.setString(i, s);
            } else {
                stmt.setString(i, o.toString());
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doDelete(WebContext context, Form data) throws BirdException {
        Connection c = (Connection)context.getAttribute("bird.connection");
        try {
            StringBuffer s = new StringBuffer(64);
            s.append("delete from ");
            s.append(context.getParameter("table"));
            s.append(" where ");
            s.append(context.getParameter("key"));
            s.append("=?");
            try (PreparedStatement stmt = c.prepareStatement(s.toString());){
                stmt.setString(1, data.getID());
                stmt.executeUpdate();
            }
            context.setRedirectPage(context.getParameter("return"));
        }
        catch (Exception e) {
            throw new BirdException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean queryOpen(WebContext context, Form data) throws BirdException {
        if (data.isEdit()) {
            Connection c = (Connection)context.getAttribute("bird.connection");
            try {
                StringBuffer s = new StringBuffer(64);
                s.append("select ");
                s.append(context.getParameter("fields"));
                s.append(" from ");
                s.append(context.getParameter("table"));
                s.append(" where ");
                s.append(context.getParameter("key", "id"));
                s.append("=?");
                try (PreparedStatement stmt = c.prepareStatement(s.toString());){
                    stmt.setString(1, data.getID());
                    try (ResultSet rs = stmt.executeQuery();){
                        if (rs.next()) {
                            ResultSetMetaData rsm = rs.getMetaData();
                            int count = rsm.getColumnCount();
                            for (int i = 1; i <= count; ++i) {
                                String name = rsm.getColumnName(i).toLowerCase();
                                data.put(name, rs.getObject(i));
                            }
                        }
                    }
                }
            }
            catch (SQLException e) {
                throw new BirdException(e);
            }
        }
        return true;
    }

    private static final String expand(int count, String token, String delim) {
        StringBuffer s = new StringBuffer(count * (delim.length() + token.length()));
        for (int i = 0; i < count; ++i) {
            if (i != 0) {
                s.append(delim);
            }
            s.append(token);
        }
        return s.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doSave(WebContext context, Form data) throws BirdException {
        boolean debug = context.getParameterInt("debug") == 1;
        Connection c = (Connection)context.getAttribute("bird.connection");
        try {
            Hashtable h = data.getHashtable();
            StringTokenizer st = new StringTokenizer(context.getParameter("fields"), ",");
            while (st.hasMoreTokens()) {
                String name = st.nextToken();
                if (h.containsKey(name)) continue;
                h.put(name, new Null(1));
            }
            StringBuffer s = new StringBuffer(64);
            if (data.isCreate()) {
                s.append("insert into ");
                s.append(context.getParameter("table"));
                s.append(" (");
                String generate_key = context.getParameter("generate_key");
                if (generate_key != null) {
                    h.put(generate_key, UID.getUID());
                }
                s.append(Util.expandKeys(h, ","));
                s.append(") values (");
                s.append(WebSQLForm.expand(h.size(), "?", ","));
                s.append(")");
            } else {
                s.append("update ");
                s.append(context.getParameter("table"));
                s.append(" set ");
                Enumeration e = h.keys();
                int i = 0;
                while (e.hasMoreElements()) {
                    if (i != 0) {
                        s.append(",");
                    }
                    String name = (String)e.nextElement();
                    s.append(name + "=?");
                    ++i;
                }
                s.append(" where ");
                s.append(context.getParameter("key"));
                s.append("=?");
            }
            if (debug) {
                System.out.println("sql=" + s);
                System.out.println("values=" + h);
            }
            try (PreparedStatement stmt = c.prepareStatement(s.toString());){
                WebSQLForm.setStatementValues(stmt, h, 1);
                if (data.isEdit()) {
                    stmt.setString(h.size() + 1, data.getID());
                }
                stmt.executeUpdate();
            }
            context.setRedirectPage(context.getParameter("return"));
        }
        catch (Exception e) {
            throw new BirdException(e);
        }
    }
}

