/*
 * Decompiled with CFR 0.152.
 */
package is.hugvit.bird;

import is.hugvit.bird.BirdException;
import is.hugvit.bird.WebContext;
import is.hugvit.bird.WebElementBase;
import is.hugvit.util.Util;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.dom4j.Element;

public final class WebPageInfo
extends WebElementBase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void doGet(WebContext context) throws BirdException {
        try {
            String pagename = context.getPageName();
            Connection c = (Connection)context.getAttribute("bird.connection");
            try (PreparedStatement stmt = c.prepareStatement("select title,author,pagedate,modified,modified_by,pagetype,description from bird_page where type='PAGE' and name=?");){
                stmt.setString(1, pagename);
                try (ResultSet rs = stmt.executeQuery();){
                    if (rs.next()) {
                        Timestamp modified;
                        Element r = context.getRootElement().addElement("bird_page_info");
                        r.addElement("name").addText(pagename);
                        r.addElement("title").addText(rs.getString(1));
                        r.addElement("author").addText(WebPageInfo.noNull(rs.getString(2)));
                        Date date = rs.getDate(3);
                        if (date != null) {
                            Element e = r.addElement("pagedate");
                            e.addText(Util.dateToISO(date));
                            e.addAttribute("text", Util.dateToShort(date));
                        }
                        if ((modified = rs.getTimestamp(4)) != null) {
                            Element e = r.addElement("modified");
                            e.addText(Util.dateTimeToISO(modified));
                            e.addAttribute("text", Util.dateTimeToShort(date));
                        }
                        r.addElement("modified_by").addText(WebPageInfo.noNull(rs.getString(5)));
                        r.addElement("pagetype").addText(WebPageInfo.noNull(rs.getString(6)));
                        r.addElement("description").addText(WebPageInfo.noNull(rs.getString(7)));
                    }
                }
            }
        }
        catch (SQLException e) {
            throw new BirdException(e);
        }
    }

    private static final String noNull(String s) {
        return s == null ? "" : s;
    }
}

