/*
 * Decompiled with CFR 0.152.
 */
package is.hugvit.bird;

import is.hugvit.bird.BirdException;
import is.hugvit.bird.Parameter;
import is.hugvit.bird.WebContext;
import is.hugvit.bird.WebElementBase;
import is.hugvit.bird.WebNotesSession;
import is.hugvit.util.Util;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import lotus.domino.Database;
import lotus.domino.DateTime;
import lotus.domino.NotesException;
import lotus.domino.Session;
import lotus.domino.View;
import lotus.domino.ViewColumn;
import lotus.domino.ViewEntry;
import lotus.domino.ViewEntryCollection;
import org.dom4j.Element;

public final class WebNotesView
extends WebElementBase {
    private static final NumberFormat nf1 = NumberFormat.getInstance();
    private static final DateFormat df = DateFormat.getDateInstance();
    private static final DateFormat tf = DateFormat.getTimeInstance();
    private static final DateFormat tf_short = DateFormat.getTimeInstance(3);
    private static final Random random = new Random();
    private static final String[] ALIGN = new String[]{"left", "right", "center"};

    public WebNotesView() {
        this.param = new Parameter[5];
        this.param[0] = new Parameter("server", "Name of the server (Default local)");
        this.param[1] = new Parameter("database", "Name of the database");
        this.param[2] = new Parameter("view", "Name of the view");
        this.param[3] = new Parameter("count", 1, "The number of entries to return (Default all)");
        this.param[4] = new Parameter("random", 2, "Returns the result in random order");
        this.desc = "Returns notes view in xml format, this works for any notes view";
    }

    private static final void doEntry(ViewEntry ve, Element root, Vector columns, NumberFormat nf2) throws NotesException {
        if (ve.isValid()) {
            Element eve = root.addElement("viewentry");
            eve.addAttribute("unid", ve.getUniversalID());
            Enumeration e1 = ve.getColumnValues().elements();
            Enumeration e2 = columns.elements();
            while (e1.hasMoreElements()) {
                Object obj = e1.nextElement();
                ViewColumn vc = (ViewColumn)e2.nextElement();
                Element ed = eve.addElement("entrydata");
                ed.addAttribute("name", vc.getItemName());
                if (obj instanceof Double) {
                    int f = vc.getNumberFormat();
                    if (f == 1) {
                        nf2.setMinimumFractionDigits(vc.getNumberDigits());
                        obj = nf2.format((Double)obj);
                    } else {
                        obj = nf1.format((Double)obj);
                    }
                } else if (obj instanceof DateTime) {
                    Date date = ((DateTime)obj).toJavaDate();
                    int fmt = vc.getTimeDateFmt();
                    if (fmt == 0) {
                        obj = df.format(date);
                    } else if (fmt == 1) {
                        int tfmt = vc.getTimeFmt();
                        obj = tfmt == 1 ? tf_short.format(date) : tf.format(date);
                    }
                } else if (obj instanceof String) {
                    obj = Util.replace(obj.toString(), "\u0000", "\r\n");
                }
                ed.addElement("text").addText(obj.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void doGet(WebContext context) throws BirdException {
        try {
            NumberFormat nf2 = NumberFormat.getInstance();
            String sserver = context.getParameter("server");
            boolean skip_recycle = context.getParameter("skip_recycle", "").equals("1");
            boolean is_random = context.getParameter("random", "").equals("1");
            String sdatabase = context.getParameter("database");
            String sview = context.getParameter("view");
            int count = context.getParameterInt("count", Integer.MAX_VALUE);
            boolean created_session = false;
            boolean thread_session = sserver == null;
            Session session = (Session)context.getAttribute("notes.session");
            if (session == null) {
                String user = context.getParameter("user");
                String password = context.getParameter("password");
                session = WebNotesSession.createSession(sserver, user, password);
                created_session = true;
            }
            try {
                int i;
                sserver = sserver == null ? "" : sserver;
                Database db = session.getDatabase(sserver, sdatabase);
                if (db == null) {
                    throw new BirdException("Database " + sdatabase + " on server \"" + sserver + "\" not found");
                }
                View view = db.getView(sview);
                if (view == null) {
                    throw new BirdException("View " + sview + " not found");
                }
                Element root = context.getRootElement().addElement("viewentries");
                root.addAttribute("name", view.getName());
                Vector v = view.getAliases();
                if (v.size() > 0) {
                    root.addAttribute("alias", (String)v.lastElement());
                }
                Vector columns = view.getColumns();
                Enumeration e = columns.elements();
                while (e.hasMoreElements()) {
                    ViewColumn vc = (ViewColumn)e.nextElement();
                    Element evc = root.addElement("viewcolumn");
                    evc.addElement("name").addText(vc.getItemName());
                    evc.addElement("title").addText(vc.getTitle());
                    evc.addElement("align").addText(ALIGN[vc.getAlignment()]);
                    evc.addElement("width").addText(vc.getWidth() + "");
                }
                ViewEntryCollection vec = view.getAllEntries();
                if (is_random) {
                    int total = vec.getCount();
                    for (i = 0; total > 0 && i < count; ++i) {
                        int pos = random.nextInt(total) + 1;
                        ViewEntry ve = vec.getNthEntry(pos);
                        WebNotesView.doEntry(ve, root, columns, nf2);
                        vec.deleteEntry(ve);
                        if (!skip_recycle) {
                            ve.recycle();
                        }
                        total = vec.getCount();
                    }
                } else {
                    ViewEntry ve = vec.getFirstEntry();
                    while (ve != null && i < count) {
                        WebNotesView.doEntry(ve, root, columns, nf2);
                        ViewEntry temp = ve;
                        ve = vec.getNextEntry();
                        if (!skip_recycle) {
                            temp.recycle();
                        }
                        ++i;
                    }
                }
            }
            finally {
                if (created_session) {
                    WebNotesSession.recycle(session, thread_session);
                }
            }
        }
        catch (NotesException e) {
            throw new BirdException(e.text, (Exception)((Object)e));
        }
    }
}

