/*
 * Decompiled with CFR 0.152.
 */
package is.hugvit.bird;

import is.hugvit.bird.BirdEngine;
import is.hugvit.bird.BirdException;
import is.hugvit.bird.WebContext;
import is.hugvit.bird.WebElementBase;
import is.hugvit.util.Util;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.dom4j.Element;

public final class WebMenu
extends WebElementBase {
    private static final String SQL_ITEMS = "select webrole,id,type,title,name from bird_page where folder=? and visible='1' order by sort";
    private static final String SQL_FOLDER = "select id from bird_page where type='FOLDER' and folder=? and title=?";
    private static final String SQL_PARENT = "select folder from bird_page where type='PAGE' and name=?";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String doItems(WebContext context, Connection c, Element root, String folder_id, boolean show_pages) throws SQLException {
        try (PreparedStatement pstmt = c.prepareStatement(SQL_ITEMS);){
            String string;
            pstmt.setString(1, folder_id);
            ResultSet rs = pstmt.executeQuery();
            try {
                String main_name = "";
                while (rs.next()) {
                    Element item;
                    String[] webroles = Util.splitArray(rs.getString(1), ";");
                    if (!context.isUserInAllRoles(webroles)) continue;
                    String id = rs.getString(2);
                    String type = rs.getString(3);
                    String title = rs.getString(4);
                    String name = rs.getString(5);
                    if (type.equals("FOLDER")) {
                        item = root.addElement("bird_item");
                        item.addAttribute("id", id);
                        item.addAttribute("type", type);
                        item.addAttribute("title", title);
                        name = WebMenu.doItems(context, c, item, id, show_pages);
                        if (name.equals("")) {
                            root.remove(item);
                            continue;
                        }
                        item.addAttribute("name", name);
                        continue;
                    }
                    if (show_pages && type.equals("PAGE")) {
                        item = root.addElement("bird_item");
                        item.addAttribute("id", id);
                        item.addAttribute("type", type);
                        item.addAttribute("title", title);
                        item.addAttribute("name", name);
                    }
                    if (!folder_id.equals("") && main_name.equals("")) {
                        main_name = name;
                        continue;
                    }
                    if (!type.equals("LINK")) continue;
                    item = root.addElement("bird_item");
                    item.addAttribute("id", id);
                    item.addAttribute("type", type);
                    item.addAttribute("title", title);
                    item.addAttribute("name", name);
                }
                string = main_name;
            }
            catch (Throwable throwable) {
                rs.close();
                throw throwable;
            }
            rs.close();
            return string;
        }
    }

    private static final Element findItem(Element folder, String pagename) {
        Iterator i = folder.elementIterator("bird_item");
        while (i.hasNext()) {
            Element r = (Element)i.next();
            String name = r.attributeValue("name");
            if (name.equalsIgnoreCase(pagename)) {
                return r;
            }
            String type = r.attributeValue("type");
            if (!type.equals("FOLDER") || (r = WebMenu.findItem(r, pagename)) == null) continue;
            return r;
        }
        return null;
    }

    private static final Element findParent(Element folder, String id) {
        Iterator i = folder.elementIterator("bird_item");
        while (i.hasNext()) {
            Element r = (Element)i.next();
            String sid = r.attributeValue("id");
            if (sid.equals(id)) {
                return r;
            }
            String type = r.attributeValue("type");
            if (!type.equals("FOLDER") || (r = WebMenu.findParent(r, id)) == null) continue;
            return r;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String getParentID(Connection c, String pagename) throws SQLException {
        String result = null;
        try (PreparedStatement stmt = c.prepareStatement(SQL_PARENT);){
            stmt.setString(1, pagename);
            try (ResultSet rs = stmt.executeQuery();){
                if (rs.next()) {
                    result = rs.getString(1);
                }
            }
        }
        return result;
    }

    private static final void markSelected(Connection c, Element r, String pagename) throws SQLException {
        Element item = WebMenu.findItem(r, pagename);
        Element parent = null;
        if (item != null) {
            String type = item.attributeValue("type");
            if (type.equals("FOLDER")) {
                item.addAttribute("open", "1");
            }
            item.addAttribute("selected", "1");
            parent = item.getParent();
        } else {
            String parent_id = WebMenu.getParentID(c, pagename);
            if (parent_id != null) {
                parent = WebMenu.findParent(r, parent_id);
            }
        }
        while (parent != null && parent.getName().equals("bird_item")) {
            parent.addAttribute("open", "1");
            parent = parent.getParent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String getFolderID(Connection c, String folder) throws SQLException {
        String id = "";
        StringTokenizer st = new StringTokenizer(folder, "\\");
        try (PreparedStatement stmt = c.prepareStatement(SQL_FOLDER);){
            while (st.hasMoreTokens()) {
                stmt.setString(1, id);
                stmt.setString(2, st.nextToken());
                try (ResultSet rs = stmt.executeQuery();){
                    if (rs.next()) {
                        id = rs.getString(1);
                        continue;
                    }
                    break;
                }
            }
        }
        return id;
    }

    @Override
    public final void doGet(WebContext context) throws BirdException {
        try {
            String name = context.getParameter("name", "main");
            boolean show_pages = context.getParameter("pages", "").equals("1");
            Connection c = (Connection)context.getAttribute("bird.connection");
            String folder = context.getParameter("folder", "");
            String id = "";
            if (!folder.equals("")) {
                id = WebMenu.getFolderID(c, folder);
            }
            Element r = context.getRootElement().addElement("bird_menu");
            r.addAttribute("name", name);
            String pagename = BirdEngine.getPageName(context.getRequest().getPathInfo());
            WebMenu.doItems(context, c, r, id, show_pages);
            WebMenu.markSelected(c, r, pagename);
        }
        catch (SQLException e) {
            throw new BirdException(e);
        }
    }
}

