/*
 * Decompiled with CFR 0.152.
 */
package is.hugvit.bird;

import is.hugvit.bird.BirdException;
import is.hugvit.bird.PageXSL;
import is.hugvit.bird.WebContext;
import is.hugvit.bird.WebElementBase;
import is.hugvit.util.Util;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class WebList
extends WebElementBase {
    private static final String SQL_IMAGE = "select filename,alt,width,height from bird_file where name=?";
    static final String SQL_FIELDS = "title,name,pagedate,description,listimage";
    static final String SQL_WHERE = "where type='PAGE' and visible='1' and status='APPROVED' and lists like ? and (startdate is null or startdate<=?) and (enddate is null or enddate>=?)";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void addImageInfo(PreparedStatement stmt, String listimage, Element item) throws SQLException {
        stmt.setString(1, listimage);
        try (ResultSet rs2 = stmt.executeQuery();){
            if (rs2.next()) {
                String filename = rs2.getString(1);
                String alt = rs2.getString(2);
                int width = rs2.getInt(3);
                int height = rs2.getInt(4);
                item.addElement("image_name").addText(listimage);
                item.addElement("filename").addText(filename);
                if (alt != null) {
                    item.addElement("alt").addText(alt);
                }
                item.addElement("width").addText(width + "");
                item.addElement("height").addText(height + "");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doGet(WebContext context) throws BirdException {
        try {
            String listname = context.getParameter("name");
            String location = context.getParameter("location");
            String element_name = context.getParameter("root", "bird_list");
            String order = context.getParameter("sort", "");
            String direction = context.getParameter("direction", "").toLowerCase();
            String dateformat = context.getParameter("dateformat", "");
            String datetype = context.getParameter("datetype", "");
            StringBuffer body = null;
            boolean showbody = context.getParameter("showbody", "").equals("1");
            boolean showdesc = context.getParameter("showdesc", "").equals("1");
            boolean showdate = context.getParameter("showdate", "").equals("1");
            boolean random = context.getParameter("random", "").equals("1");
            boolean showtextbody = context.getParameter("showtextbody", "").equals("1");
            int count = context.getParameterInt("count", 0);
            Element list = context.getRootElement().addElement(element_name);
            if (listname != null) {
                list.addAttribute("name", listname);
            }
            if (location != null) {
                list.addAttribute("location", location);
            }
            Connection dc = (Connection)context.getAttribute("bird.connection");
            StringBuffer s = new StringBuffer(128);
            s.append("select ");
            s.append(SQL_FIELDS);
            if (showtextbody) {
                s.append(",textbody");
            }
            if (showbody) {
                s.append(",body");
                body = new StringBuffer(4096);
                PageXSL.addEntities(body);
                body.append("<root>");
            }
            s.append(" from bird_page ");
            s.append(SQL_WHERE);
            if (random) {
                s.append(" order by rand()");
            } else if (!order.equals("")) {
                s.append(" order by ");
                s.append(order);
                if (direction.equals("desc")) {
                    s.append(" desc");
                }
            }
            try (PreparedStatement stmt = dc.prepareStatement(s.toString());
                 PreparedStatement stmt2 = dc.prepareStatement(SQL_IMAGE);){
                stmt.setMaxRows(count);
                stmt2.setMaxRows(1);
                Date now = new Date(System.currentTimeMillis());
                stmt.setString(1, '%' + listname + ";%");
                stmt.setDate(2, now);
                stmt.setDate(3, now);
                try (ResultSet rd = stmt.executeQuery();){
                    while (rd.next()) {
                        String df;
                        Element item = list.addElement("page");
                        String title = rd.getString(1);
                        String name = rd.getString(2);
                        Date date = rd.getDate(3);
                        String desc = rd.getString(4);
                        String listimage = rd.getString(5);
                        String textbody = null;
                        if (showtextbody) {
                            textbody = rd.getString(6);
                        }
                        if (showbody) {
                            body.append("<body>");
                            body.append(rd.getString("body"));
                            body.append("</body>");
                        }
                        item.addElement("title").addText(title);
                        item.addElement("name").addText(name);
                        if (textbody != null) {
                            item.addElement("textbody").addText(textbody);
                        }
                        if (showdesc && !desc.equals("")) {
                            item.addElement("description").addText(desc);
                        }
                        if (listimage != null && !listimage.equals("")) {
                            WebList.addImageInfo(stmt2, listimage, item);
                        }
                        if (!showdate) continue;
                        if (datetype.equals("")) {
                            df = Util.dateToShort(date);
                        } else {
                            if (!datetype.equals("CUSTOM")) {
                                dateformat = datetype;
                            }
                            df = Util.formatDate(dateformat, date);
                        }
                        item.addElement("date").addText(df);
                    }
                }
            }
            if (showbody) {
                body.append("</root>");
                SAXReader reader = new SAXReader();
                Document doc = reader.read((Reader)new StringReader(body.toString()));
                Element root = doc.getRootElement();
                Iterator i1 = list.elementIterator();
                while (i1.hasNext()) {
                    Element epage = (Element)i1.next();
                    epage.add(root.node(0).detach());
                }
            }
        }
        catch (DocumentException e) {
            throw new BirdException((Exception)((Object)e));
        }
        catch (SQLException e) {
            throw new BirdException(e);
        }
    }
}

