/*
 * Decompiled with CFR 0.152.
 */
package is.hugvit.bird;

import is.hugvit.bird.BirdException;
import is.hugvit.bird.WebContextImpl;
import is.hugvit.bird.WebElement;
import is.hugvit.log.Log;
import is.hugvit.util.HashMapEx;
import java.util.Iterator;
import org.dom4j.Document;
import org.dom4j.Element;

final class WebElementData
implements Comparable {
    private int order = Integer.MAX_VALUE;
    private long cache_time;
    private long creation_time = System.currentTimeMillis();
    private Document doc;
    String name;
    WebElement we;
    HashMapEx param;

    WebElementData(String name, WebElement we, HashMapEx param) {
        this.name = name;
        this.we = we;
        this.param = param;
        if (param != null) {
            String s = param.getProperty("bird.order");
            if (s != null) {
                this.order = Integer.parseInt(s);
            }
            if ((s = param.getProperty("bird.cache")) != null) {
                this.cache_time = Integer.parseInt(s) * 60 * 1000;
            }
        }
    }

    private final void cloneElements(Element root) {
        Iterator i = this.doc.getRootElement().elementIterator();
        while (i.hasNext()) {
            Element e1 = (Element)i.next();
            Element e2 = (Element)e1.clone();
            root.add(e2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void doGet(WebContextImpl wcontext, Log log) throws BirdException {
        long begin = System.currentTimeMillis();
        if (this.cache_time > 0L) {
            boolean in_valid;
            boolean bl = in_valid = this.doc == null || this.cache_time + this.creation_time < begin;
            if (in_valid) {
                Document newdoc = WebContextImpl.df.createDocument(WebContextImpl.df.createElement("data"));
                Document temp = wcontext.doc;
                wcontext.doc = newdoc;
                try {
                    this.we.doGet(wcontext);
                    this.doc = newdoc;
                    this.creation_time = begin;
                    if (log.getLevel() >= 0) {
                        long end = System.currentTimeMillis();
                        log.debug("Time:" + this.name + '=' + (end - begin));
                    }
                }
                finally {
                    wcontext.doc = temp;
                }
                log.debug("Caching: " + this.name);
            }
            this.cloneElements(wcontext.getRootElement());
        } else {
            this.we.doGet(wcontext);
            if (log.getLevel() >= 0) {
                long end = System.currentTimeMillis();
                log.debug("Time:" + this.name + '=' + (end - begin));
            }
        }
    }

    public final int compareTo(Object o) {
        WebElementData wed2 = (WebElementData)o;
        return this.order - wed2.order;
    }

    public final String toString() {
        return this.we.toString();
    }
}

