/*
 * Decompiled with CFR 0.152.
 */
package is.hugvit.bird;

import is.hugvit.bird.BirdEngine;
import is.hugvit.bird.BirdException;
import is.hugvit.bird.BirdSession;
import is.hugvit.bird.BirdSessionImpl;
import is.hugvit.bird.GenericPrincipal;
import is.hugvit.bird.WebContext;
import is.hugvit.bird.WebElementData;
import is.hugvit.net.HttpUtil;
import is.hugvit.util.Base64;
import is.hugvit.util.HashMapEx;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.dom4j.Document;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;

final class WebContextImpl
implements WebContext {
    private HashMap attributes;
    static final DocumentFactory df = new DocumentFactory();
    HttpServletRequest req;
    HttpServletResponse res;
    String redirect;
    boolean cont_flag = true;
    BirdEngine engine;
    Document doc;
    boolean element_taken;
    HashMapEx param;
    Connection conn;
    boolean is_admin;
    boolean is_admin_page;
    boolean is_post;
    boolean is_debug_xsl;
    boolean is_debug_xml;
    String pathinfo;
    String pagename;
    GenericPrincipal principal;

    WebContextImpl(BirdEngine engine, HttpServletRequest req, HttpServletResponse res, boolean isfile) {
        this.engine = engine;
        this.req = req;
        this.res = res;
        if (!isfile) {
            this.attributes = new HashMap();
            this.param = new HashMapEx();
            this.clear();
            this.pathinfo = HttpUtil.getPathInfo(req).toLowerCase();
            this.is_admin = this.pathinfo.startsWith("/admin/");
            this.is_admin_page = this.pathinfo.startsWith("/admin/$pages/");
            this.is_post = req.getMethod().equalsIgnoreCase("post");
            String qs = req.getQueryString();
            if (qs != null && engine.bird_config.getDebug()) {
                this.is_debug_xsl = qs.endsWith("output=xsl");
                this.is_debug_xml = qs.endsWith("output=xml");
            }
            this.pagename = BirdEngine.getPageName(this.pathinfo);
        }
        String username = req.getRemoteUser();
        String auth = req.getHeader("Authorization");
        if (username == null && auth != null) {
            this.principal = this.getPrincipal(auth);
        }
    }

    private final GenericPrincipal getPrincipal(String auth) {
        String userpass;
        int pos;
        GenericPrincipal p = null;
        HttpSession session = this.req.getSession();
        if (auth.toLowerCase().startsWith("basic ") && (pos = (userpass = Base64.decodeToString(auth.substring(6))).indexOf(58)) > -1) {
            String username = userpass.substring(0, pos);
            String password = userpass.substring(pos + 1);
            p = (GenericPrincipal)session.getAttribute("bird.principal");
            if (!(p == null || username.equals(p.getName()) && password.equals(p.getPassword()))) {
                session.removeAttribute("bird.principal");
                p = null;
            }
            if (p == null) {
                p = (GenericPrincipal)this.engine.getRealm().authenticate(username, password);
                session.setAttribute("bird.principal", (Object)p);
            }
        }
        return p;
    }

    final void createConnection() throws SQLException {
        this.conn = this.engine.connect();
        this.setAttribute("bird.connection", this.conn);
    }

    final void clear() {
        Element root = df.createElement("data");
        this.doc = df.createDocument(root);
        this.redirect = null;
        this.element_taken = false;
        this.cont_flag = true;
    }

    final void destroy() {
        if (this.conn != null) {
            try {
                this.conn.close();
            }
            catch (SQLException e) {
                this.engine.log.error(e);
            }
        }
    }

    @Override
    public final boolean isUserInAllRoles(String[] roles) {
        for (int i = roles.length - 1; i >= 0; --i) {
            if (this.isUserInRole(roles[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public final String getParameter(String name) {
        return this.param.getProperty(name);
    }

    @Override
    public final void setParameter(String name, String value) {
        this.param.put(name, value);
    }

    final void assign(WebElementData wed) {
        this.param = wed.param;
    }

    @Override
    public final String getParameter(String name, String def) {
        String s = this.param.getProperty(name);
        if (s != null) {
            return s;
        }
        return def;
    }

    @Override
    public final Map getParameters() {
        return this.param;
    }

    @Override
    public final int getParameterInt(String name) {
        return this.getParameterInt(name, 0);
    }

    private final Object getRequestAttribute(String name) {
        return this.req.getAttribute(name);
    }

    private final void setRequestAttribute(String name, Object value) {
        this.req.setAttribute(name, value);
    }

    private final boolean isUserInRoleRequest(String role) {
        return this.req.isUserInRole(role);
    }

    @Override
    public final Object getAttribute(String name) {
        if (this.engine.use_request) {
            return this.getRequestAttribute(name);
        }
        return this.attributes.get(name);
    }

    @Override
    public final void setAttribute(String name, Object value) {
        if (this.engine.use_request) {
            this.setRequestAttribute(name, value);
        } else {
            this.attributes.put(name, value);
        }
    }

    @Override
    public final String getRemoteUser() {
        if (this.principal != null) {
            return this.principal.getName();
        }
        return this.req.getRemoteUser();
    }

    @Override
    public final boolean isUserInRole(String role) {
        if (this.principal != null) {
            return this.principal.hasRole(role);
        }
        if (this.engine.use_request) {
            return this.isUserInRoleRequest(role);
        }
        return true;
    }

    @Override
    public final int getParameterInt(String name, int def) {
        String s = this.getParameter(name);
        if (s != null) {
            try {
                return Integer.parseInt(s);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return def;
    }

    @Override
    public final HttpServletRequest getRequest() {
        return this.req;
    }

    @Override
    public final HttpServletResponse getResponse() {
        return this.res;
    }

    @Override
    public final HttpServletResponse getResponseExclusive() {
        this.cont_flag = false;
        return this.res;
    }

    @Override
    public final Element getRootElement() {
        this.element_taken = true;
        return this.doc.getRootElement();
    }

    public final Document getDocument() {
        return this.doc;
    }

    @Override
    public final BirdSession getSession() {
        return new BirdSessionImpl(this.engine, this);
    }

    @Override
    public final void setRedirectURL(String url) {
        if (url.indexOf("://") > -1) {
            this.redirect = url;
        } else {
            StringBuffer s = new StringBuffer(HttpUtil.getPathURL(this.req));
            s.append(url);
            this.redirect = s.toString();
        }
    }

    @Override
    public final void setRedirectPage(String page) {
        this.redirect = this.engine.getURL(this, page);
    }

    @Override
    public final void setRedirectPage(String page, String parameters) {
        String url = this.engine.getURL(this, page);
        if (parameters != null && !parameters.equals("")) {
            url = url + "?" + parameters;
        }
        this.redirect = url;
    }

    @Override
    public final String getRedirectURL() {
        return this.redirect;
    }

    final Connection getConnection() throws SQLException {
        return this.conn;
    }

    @Override
    public final Connection connect() throws BirdException {
        try {
            return this.engine.connect();
        }
        catch (SQLException e) {
            throw new BirdException(e);
        }
    }

    @Override
    public final String getPageName() {
        return BirdEngine.getPageName(this.req.getPathInfo());
    }

    final void setStatusUnAuthorizedEx() throws ServletException {
        this.engine.log.debug("Setting status SC_UNAUTHORIZED");
        this.engine.log.debug("AuthType=" + this.engine.auth_method);
        String realm = this.engine.realm_name;
        if (realm.equals("")) {
            realm = this.engine.bird_config.getName();
        }
        this.res.setStatus(401);
        this.res.setHeader("WWW-Authenticate", this.engine.auth_method + " realm=\"" + realm + "\"");
    }

    @Override
    public final void setStatusUnAuthorized() throws BirdException {
        try {
            this.setStatusUnAuthorizedEx();
            this.cont_flag = false;
        }
        catch (ServletException e) {
            throw new BirdException((Exception)((Object)e));
        }
    }
}

