/*
 * Decompiled with CFR 0.152.
 */
package is.hugvit.bird;

import is.hugvit.bird.BirdSession;
import is.hugvit.bird.DefaultRealm;
import is.hugvit.bird.GenericPrincipal;
import is.hugvit.util.HashMapEx;
import is.hugvit.util.Util;
import java.io.File;
import java.security.Principal;
import java.util.List;
import java.util.Properties;
import javax.servlet.ServletContext;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class TomcatRealm
extends DefaultRealm {
    protected HashMapEx users = new HashMapEx();

    @Override
    public String getInfo() {
        return "TomcatRealm/1.0";
    }

    @Override
    public final void setSession(BirdSession session) {
        super.setSession(session);
        try {
            ServletContext context = session.getServletContext();
            if (context != null) {
                Properties p = session.getParameters();
                File file = new File(p.getProperty("realm.filename"));
                SAXReader reader = new SAXReader();
                Document doc = reader.read(file);
                Element root = doc.getRootElement();
                HashMapEx all_roles = new HashMapEx();
                for (Element e : root.elements("user")) {
                    String username = e.attributeValue("username");
                    String password = e.attributeValue("password");
                    List roles = Util.splitList(e.attributeValue("roles"), ",");
                    all_roles.putAll(roles);
                    GenericPrincipal gp = new GenericPrincipal(username, password, roles);
                    this.users.put(username, gp);
                }
                for (Element e : root.elements("role")) {
                    all_roles.put(e.attributeValue("rolename"), null);
                }
                this.roles = all_roles.toStrings();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public final Principal authenticate(String username, String credentials) {
        GenericPrincipal p = (GenericPrincipal)this.users.get(username);
        if (p != null && p.getPassword().equals(credentials)) {
            return p;
        }
        return null;
    }
}

