/*
 * Decompiled with CFR 0.152.
 */
package is.hugvit.bird;

import is.hugvit.bird.DefaultRealm;
import is.hugvit.bird.GenericPrincipal;
import is.hugvit.sql.SQLUtil;
import is.hugvit.util.ArrayListEx;
import java.security.Principal;
import java.sql.Connection;
import java.util.Properties;

public class SQLRealm
extends DefaultRealm {
    @Override
    public String getInfo() {
        return "SQLRealm/1.0";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final String[] getRoles() {
        String[] roles = null;
        try {
            Properties p = this.session.getParameters();
            String d = p.getProperty("realm.driver");
            try (Connection c = d == null ? this.session.getDatabase().connect() : SQLUtil.connect("realm.", p);){
                roles = SQLUtil.getStrings(c, p.getProperty("realm.sql_all_roles"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return roles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final Principal authenticate(String username, String credentials) {
        try {
            Properties p = this.session.getParameters();
            String d = p.getProperty("realm.driver");
            try (Connection c = d == null ? this.session.getDatabase().connect() : SQLUtil.connect("realm.", p);){
                String password = SQLUtil.getString(c, p.getProperty("realm.sql_password"), username);
                if (password == null) return null;
                String[] roles = SQLUtil.getStrings(c, p.getProperty("realm.sql_user_roles"), username);
                ArrayListEx list = new ArrayListEx(roles);
                GenericPrincipal genericPrincipal = new GenericPrincipal(username, password, list);
                return genericPrincipal;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

