/*
 * Decompiled with CFR 0.152.
 */
package is.hugvit.bird;

import is.hugvit.bird.BirdEngine;
import is.hugvit.bird.WebContextImpl;
import is.hugvit.bird.WebElement;
import is.hugvit.bird.WebElementData;
import is.hugvit.bird.WebList;
import is.hugvit.io.ByteArrayOutputStreamEx;
import is.hugvit.io.StringReaderEx;
import is.hugvit.util.ArrayListEx;
import is.hugvit.util.HashMapEx;
import is.hugvit.util.Util;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.dom4j.Document;
import org.dom4j.io.DocumentSource;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

class PageXSL {
    private static final String SQL_PAGE = "select title,pagetype,templates,elements,body,alias,showlist,listcount,status,startdate,enddate,alttitle,description,author,webrole,role,lang from bird_page where type='PAGE' and LOWER(name)=?";
    private static final String SQL_PAGETYPE = "select templates,elements,head,body from bird_pagetype where name=?";
    private static final String SQL_TEMPLATE = "select type,body from bird_template where name=?";
    private static final String SQL_LIST = "select sort,direction,showdesc,showdate,template,type,dateformat,datetype,showbody from bird_list where name=?";
    private static final String SQL_ELEMENT = "select classname,parameters from bird_element where name=?";
    private static final String UTF8 = "UTF-8";
    protected String title;
    protected String alttitle = "";
    private String pagename;
    private String alias;
    private String pagetype;
    private String description = "";
    private String author = "";
    private ArrayListEx templates;
    private ArrayListEx elements;
    private String[] webrole;
    private String[] role;
    private String body;
    private String showlist;
    private String language;
    private Date startdate;
    private Date enddate;
    private int listcount;
    private String status;
    protected String xsl;
    protected Templates xsl_template;
    protected ArrayListEx webelementsdata = new ArrayListEx();
    private ByteArrayOutputStreamEx out;
    private long modified = -1L;
    private static final HashMap doctype_public = new HashMap();
    private static final HashMap doctype_system = new HashMap();
    private static final HashMap entity = new HashMap();

    protected PageXSL() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final PageXSL createPage(BirdEngine engine, WebContextImpl wc, String pagename) throws Exception {
        if (pagename == null || pagename.equals("")) {
            return null;
        }
        Connection c = wc.getConnection();
        PageXSL p = null;
        try (PreparedStatement stmt = c.prepareStatement(SQL_PAGE);){
            stmt.setString(1, pagename.toLowerCase());
            try (ResultSet rd = stmt.executeQuery();){
                if (rd.next()) {
                    p = new PageXSL();
                    p.pagename = pagename;
                    p.title = rd.getString(1);
                    p.pagetype = rd.getString(2);
                    p.templates = new ArrayListEx(rd.getString(3));
                    p.elements = new ArrayListEx(rd.getString(4));
                    p.body = rd.getString(5);
                    String s = rd.getString(6);
                    p.alias = s == null ? "" : s;
                    s = rd.getString(7);
                    p.showlist = s == null ? "" : s;
                    p.listcount = rd.getInt(8);
                    p.status = rd.getString(9);
                    p.startdate = rd.getDate(10);
                    p.enddate = rd.getDate(11);
                    s = rd.getString(12);
                    p.alttitle = s == null ? "" : s;
                    s = rd.getString(13);
                    p.description = s == null ? "" : s;
                    s = rd.getString(14);
                    p.author = s == null ? "" : s;
                    p.webrole = Util.splitArray(rd.getString(15), ";");
                    p.role = Util.splitArray(rd.getString(16), ";");
                    p.language = rd.getString(17);
                }
            }
        }
        if (p != null) {
            p.doXSL(engine, c);
            Collections.sort(p.webelementsdata);
        }
        return p;
    }

    private static final void appendMeta(StringBuffer s, String name, String content, boolean http) {
        if (!content.equals("")) {
            s.append("<meta ");
            if (http) {
                s.append("http-equiv");
            } else {
                s.append("name");
            }
            s.append("=\"");
            s.append(name);
            s.append("\" content=\"");
            s.append(content);
            s.append("\"/>");
        }
    }

    final boolean isInRole(WebContextImpl wcontext) {
        if (wcontext.is_admin) {
            return wcontext.isUserInAllRoles(this.role);
        }
        for (int i = 0; i < this.webrole.length; ++i) {
        }
        return wcontext.isUserInAllRoles(this.webrole);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void doXSL(BirdEngine engine, Connection conn) throws Exception {
        boolean has_pagetype = false;
        String ptbody = null;
        String pthead = null;
        ArrayListEx v1 = null;
        ArrayListEx v2 = null;
        if (this.pagetype != null && !this.pagetype.equals("")) {
            try (PreparedStatement stmt = conn.prepareStatement(SQL_PAGETYPE);){
                stmt.setString(1, this.pagetype);
                try (ResultSet rd = stmt.executeQuery();){
                    if (rd.next()) {
                        has_pagetype = true;
                        v1 = new ArrayListEx(rd.getString(1), ";");
                        v2 = new ArrayListEx(rd.getString(2), ";");
                        pthead = rd.getString(3);
                        ptbody = rd.getString(4);
                    } else {
                        engine.log.warn("Pagetype " + this.pagetype + " not found");
                    }
                }
            }
        }
        StringBuffer s = new StringBuffer(8192);
        boolean frames = ptbody != null && ptbody.startsWith("<frameset");
        PageXSL.addXSLHeader(engine, s, frames);
        this.addList(conn, s, this.showlist);
        PageXSL.addTemplates(engine, conn, s, this.templates);
        this.addElements(engine, conn, this.elements);
        if (has_pagetype) {
            PageXSL.addTemplates(engine, conn, s, v1);
            this.addElements(engine, conn, v2);
        }
        s.append("<xsl:template name=\"bird_body\">");
        s.append(this.body);
        s.append("</xsl:template>");
        this.addMainTemplate(engine, s, pthead, ptbody, false);
        s.append("</xsl:stylesheet>");
        this.xsl = s.toString();
    }

    final void addMainTemplate(BirdEngine engine, StringBuffer s, String pthead, String ptbody, boolean nocache) throws IOException {
        String doctype = engine.bird_config.getDocType();
        String t = this.alttitle.equals("") ? this.title : this.alttitle;
        boolean xhtml = doctype.startsWith("xhtml");
        if (this.language != null) {
            s.append("<xsl:template match=\"/\"><html lang=\"" + this.language + "\"><head>");
        } else {
            s.append("<xsl:template match=\"/\"><html><head>");
        }
        if (xhtml) {
            // empty if block
        }
        if (doctype.equals("html5")) {
            String metaCharset = "<meta charset=\"" + engine.bird_config.getEncoding() + "\"/>";
            s.append(metaCharset);
        }
        PageXSL.appendMeta(s, "Generator", engine.getMetaGenerator(), false);
        PageXSL.appendMeta(s, "Author", this.author, false);
        PageXSL.appendMeta(s, "Description", Util.escapeMarkupAttribute(Util.trimWords(this.description)), false);
        if (nocache) {
            PageXSL.appendMeta(s, "Pragma", "no-cache", true);
            PageXSL.appendMeta(s, "Expires", "Tue, 01 Jan 1980 00:00:00 GMT", true);
        }
        s.append("<title>");
        s.append(Util.escapeMarkup(t));
        s.append("</title>");
        if (pthead != null) {
            s.append(pthead);
        }
        s.append("</head>");
        if (ptbody == null || ptbody.equals("")) {
            ptbody = Util.getResourceString(this, "core/files/body.html");
        }
        s.append(ptbody);
        s.append("</html></xsl:template>");
    }

    final void parse(BirdEngine engine) throws Exception {
        StringReaderEx r = new StringReaderEx(this.xsl);
        this.xsl_template = engine.transfactory.newTemplates(new StreamSource(r));
    }

    private static final void appendDocType(StringBuffer s, String doctype, boolean frames, boolean xhtml) {
        String pub;
        if (frames) {
            doctype = (xhtml ? "x" : "") + "html_frameset";
        }
        if ((pub = (String)doctype_public.get(doctype)) != null) {
            s.append(" doctype-public=\"");
            s.append(pub);
            s.append('\"');
            String sys = (String)doctype_system.get(doctype);
            if (sys != null) {
                s.append(" doctype-system=\"");
                s.append(sys);
                s.append('\"');
            }
        }
    }

    private static final String getString(boolean b) {
        return b ? "yes" : "no";
    }

    private static final void addParam(StringBuffer s, Hashtable h) {
        Enumeration e = h.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            s.append("<xsl:param name=\"");
            s.append(key);
            s.append("\">");
            s.append((String)h.get(key));
            s.append("</xsl:param>");
        }
    }

    static final void addEntities(StringBuffer s) {
        s.append("<!DOCTYPE stylesheet [");
        for (String name : entity.keySet()) {
            String value = (String)entity.get(name);
            s.append("<!ENTITY ");
            s.append(name);
            s.append(" \"&#");
            s.append(value);
            s.append(";\">");
        }
        s.append("]>");
    }

    private static final void addNamespace(Properties p, StringBuffer s, StringBuffer ns) {
        Enumeration<?> e = p.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            s.append(" xmlns:");
            s.append(key);
            s.append("=\"");
            s.append(p.getProperty(key));
            s.append('\"');
            ns.append(' ');
            ns.append(key);
        }
    }

    protected static final void addXSLHeader(BirdEngine engine, StringBuffer s, boolean frames) {
        String encoding = engine.bird_config.getEncoding();
        String doctype = engine.bird_config.getDocType();
        boolean xhtml = doctype.startsWith("xhtml");
        boolean html5 = doctype.equals("html5");
        Properties p = engine.getParameters();
        s.append("<?xml version=\"1.0\" encoding =\"");
        s.append(encoding);
        s.append("\"?>");
        PageXSL.addEntities(s);
        s.append("<xsl:stylesheet version=\"1.0\"");
        if (xhtml) {
            s.append(" xmlns=\"http://www.w3.org/1999/xhtml\"");
        }
        s.append(" xmlns:bird=\"http://www.hugvit.is/bird\"");
        s.append(" xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\"");
        StringBuffer ns = new StringBuffer(64);
        ns.append("bird");
        PageXSL.addNamespace(engine.bird_config.getNamespaces(), s, ns);
        s.append(" exclude-result-prefixes=\"");
        s.append(ns.toString());
        s.append("\">");
        s.append("<xsl:output method=\"");
        if (xhtml) {
            s.append("xhtml");
        } else {
            s.append("html");
        }
        s.append("\" indent=\"");
        s.append(PageXSL.getString(engine.bird_config.useIndent()));
        s.append("\" encoding=\"");
        s.append(encoding);
        s.append('\"');
        if (html5) {
            s.append(" omit-xml-declaration=\"yes\"");
            s.append(" version=\"5.0\"");
            s.append(" include-content-type=\"no\"");
        } else if (xhtml) {
            s.append(" omit-xml-declaration=\"");
            s.append(PageXSL.getString(encoding.equals(UTF8)));
            s.append('\"');
        }
        if (!doctype.equals("")) {
            PageXSL.appendDocType(s, doctype, frames, xhtml);
        }
        s.append("/>");
        if (p != null) {
            PageXSL.addParam(s, p);
        }
        PageXSL.addParam(s, engine.bird_config.getParameters());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void addTemplates(BirdEngine engine, Connection dsc, StringBuffer s, ArrayListEx v) throws SQLException {
        try (PreparedStatement stmt = dsc.prepareStatement(SQL_TEMPLATE);){
            Enumeration e = v.elements();
            while (e.hasMoreElements()) {
                String n = (String)e.nextElement();
                stmt.setString(1, n);
                try (ResultSet rd = stmt.executeQuery();){
                    if (rd.next()) {
                        String type = rd.getString(1);
                        String body = rd.getString(2);
                        if (type.equals("CUSTOM")) {
                            s.append(body);
                            continue;
                        }
                        s.append("<xsl:template name=\"");
                        s.append(n);
                        s.append("\">");
                        s.append(body);
                        s.append("</xsl:template>");
                        continue;
                    }
                    engine.log.warn("Template " + n + " not found");
                }
            }
        }
    }

    private final void addElements(BirdEngine engine, Connection c, ArrayListEx v) throws Exception {
        Enumeration e = v.elements();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            WebElementData we = PageXSL.getWebElementData(engine, c, name);
            if (we == null) {
                engine.log.warn("Element " + name + " not found");
                continue;
            }
            this.webelementsdata.addElement(we);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void addList(Connection dc, StringBuffer s, String name) throws Exception {
        if (!name.equals("")) {
            try (PreparedStatement stmt = dc.prepareStatement(SQL_LIST);){
                stmt.setMaxRows(1);
                stmt.setString(1, name);
                try (ResultSet rd = stmt.executeQuery();){
                    if (rd.next()) {
                        String showbody;
                        String sort = rd.getString(1);
                        String direction = rd.getString(2);
                        String t = rd.getString(3);
                        String showdesc = t == null ? "" : t;
                        t = rd.getString(4);
                        String showdate = t == null ? "" : t;
                        String xtemplate = rd.getString(5);
                        String type = rd.getString(6);
                        String dateformat = rd.getString(7);
                        String datetype = rd.getString(8);
                        t = rd.getString(9);
                        String string = showbody = t == null ? "" : t;
                        if (type.equals("FLAT")) {
                            xtemplate = "bird:list_flat";
                        }
                        this.templates.addElement(xtemplate);
                        HashMapEx p = new HashMapEx(16);
                        p.put("name", name);
                        p.put("sort", sort);
                        p.put("direction", direction);
                        p.put("count", this.listcount + "");
                        p.put("dateformat", dateformat);
                        p.put("datetype", datetype);
                        p.put("location", "body");
                        p.put("showdesc", showdesc);
                        p.put("showdate", showdate);
                        p.put("showbody", showbody);
                        WebList we = new WebList();
                        this.webelementsdata.addElement(new WebElementData("bird:list", we, p));
                        return;
                    }
                }
            }
        }
        s.append("<xsl:template name=\"bird_list\"/>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final synchronized WebElementData getWebElementData(BirdEngine engine, Connection dc, String name) throws Exception {
        WebElementData wd = engine.cache.getElement(name);
        if (wd == null) {
            try (PreparedStatement stmt = dc.prepareStatement(SQL_ELEMENT);){
                stmt.setString(1, name);
                try (ResultSet rd = stmt.executeQuery();){
                    if (rd.next()) {
                        String classname = rd.getString(1);
                        String body = rd.getString(2);
                        HashMapEx param = new HashMapEx(body);
                        WebElement we = (WebElement)Class.forName(classname).newInstance();
                        wd = new WebElementData(name, we, param);
                        engine.cache.putElement(wd);
                    }
                }
            }
        }
        return wd;
    }

    private static final Source getSourceFromDocument(Document doc) throws Exception {
        SAXSource ss;
        DocumentSource ds = new DocumentSource(doc);
        InputSource is = ds.getInputSource();
        try {
            XMLReader xr = XMLReaderFactory.createXMLReader();
            ss = new SAXSource(xr, is);
        }
        catch (SAXException e) {
            ss = new SAXSource(is);
        }
        return ss;
    }

    final ByteArrayOutputStreamEx transform(BirdEngine engine, Document doc) throws Exception {
        long begin = System.currentTimeMillis();
        boolean is_debug = engine.log.getLevel() == 0;
        ByteArrayOutputStreamEx temp = new ByteArrayOutputStreamEx(4096);
        Transformer t = this.xsl_template.newTransformer();
        Source ss = PageXSL.getSourceFromDocument(doc);
        StreamResult result = new StreamResult(temp);
        t.transform(ss, result);
        if (this.webelementsdata.size() == 0) {
            if (is_debug) {
                engine.log.debug("Caching HTML: " + this.pagename);
            }
            this.modified = System.currentTimeMillis();
            this.out = temp;
        }
        if (is_debug) {
            long end = System.currentTimeMillis();
            engine.log.debug("Time:Transform=" + (end - begin));
        }
        return temp;
    }

    final String getXSL() {
        return this.xsl;
    }

    final ArrayListEx getWebElements() {
        return this.webelementsdata;
    }

    final boolean isVisible() {
        boolean b;
        boolean bl = b = this.status.equals("") || this.status.equals("APPROVED") || this.status.equals("APPROVEDEDIT");
        if (b) {
            Date now = new Date();
            if (this.startdate != null && this.startdate.after(now)) {
                return false;
            }
            if (this.enddate != null && this.enddate.before(now)) {
                return false;
            }
        }
        return b;
    }

    final String getPageName() {
        return this.pagename;
    }

    final String getAlias() {
        return this.alias;
    }

    final long getLastModified() {
        return this.modified;
    }

    final ByteArrayOutputStreamEx getLastOutput() {
        return this.out;
    }

    static {
        doctype_public.put("html_transitional", "-//W3C//DTD HTML 4.01 Transitional//EN");
        doctype_public.put("html_strict", "-//W3C//DTD HTML 4.01//EN");
        doctype_public.put("xhtml_transitional", "-//W3C//DTD XHTML 1.0 Transitional//EN");
        doctype_public.put("xhtml_strict", "-//W3C//DTD XHTML 1.0 Strict//EN");
        doctype_public.put("xhtml11", "-//W3C//DTD XHTML 1.1//EN");
        doctype_public.put("xhtml_frameset", "-//W3C//DTD XHTML 1.0 Frameset//EN");
        doctype_public.put("html_frameset", "-//W3C//DTD HTML 4.01 Frameset//EN");
        doctype_public.put("html5", "");
        doctype_system.put("html_transitional", "http://www.w3.org/TR/html4/loose.dtd");
        doctype_system.put("html_strict", "http://www.w3.org/TR/html4/strict.dtd");
        doctype_system.put("xhtml_transitional", "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd");
        doctype_system.put("xhtml_strict", "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd");
        doctype_system.put("xhtml11", "http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd");
        doctype_system.put("xhtml_frameset", "http://www.w3.org/TR/xhtml1/DTD/xhtml1-frameset.dtd");
        doctype_system.put("html_frameset", "http://www.w3.org/TR/html4/frameset.dtd");
        doctype_system.put("html5", "about:legacy-compat");
        entity.put("nbsp", "160");
        entity.put("shy", "173");
        entity.put("copy", "169");
        entity.put("times", "215");
    }
}

