/*
 * Decompiled with CFR 0.152.
 */
package is.hugvit.bird;

import java.security.Principal;
import java.util.Arrays;
import java.util.List;

public class GenericPrincipal
implements Principal {
    protected String userId;
    protected String name;
    protected String password;
    protected String[] roles;

    public GenericPrincipal(String name, String password, List roles) {
        this.name = name;
        this.password = password;
        this.roles = new String[roles.size()];
        this.roles = roles.toArray(this.roles);
        if (this.roles.length > 0) {
            Arrays.sort(this.roles);
        }
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getPassword() {
        return this.password;
    }

    public String[] getRoles() {
        return this.roles;
    }

    public boolean hasRole(String role) {
        return Arrays.binarySearch(this.roles, role) >= 0;
    }

    @Override
    public String toString() {
        StringBuffer s = new StringBuffer(128);
        s.append("name=");
        s.append(this.name);
        s.append(" roles=[");
        for (int i = 0; i < this.roles.length; ++i) {
            if (i != 0) {
                s.append(',');
            }
            s.append(this.roles[i]);
        }
        s.append(']');
        return s.toString();
    }
}

