/*
 * Decompiled with CFR 0.152.
 */
package is.hugvit.bird;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.activation.URLDataSource;
import org.apache.axis.attachments.AttachmentPart;
import org.apache.axis.client.Call;
import org.apache.axis.client.Service;

public final class BirdServiceProxy {
    private final Service service = new Service();
    private Map attachments = new HashMap();
    private URL url;

    public BirdServiceProxy() {
    }

    public BirdServiceProxy(String url) throws MalformedURLException {
        this.url = new URL(url);
    }

    public final void setEndPoint(URL url) {
        this.url = url;
    }

    public final void setEndPoint(String url) throws MalformedURLException {
        this.url = new URL(url);
    }

    public final URL getEndPoint() {
        return this.url;
    }

    public final void addAttachment(String cid, DataSource ds) {
        this.attachments.put(cid, ds);
    }

    public final void addAttachment(String cid, File file) {
        this.addAttachment(cid, (DataSource)new FileDataSource(file));
    }

    public final Map getAttachments() {
        return this.attachments;
    }

    public final void addAttachment(String cid, URL url) {
        this.addAttachment(cid, (DataSource)new URLDataSource(url));
    }

    private final String invoke(String name, Object[] param) throws Exception {
        Call call = (Call)this.service.createCall();
        call.setTargetEndpointAddress(this.url);
        call.setOperationName(name);
        if (this.attachments.size() > 0) {
            for (String cid : this.attachments.keySet()) {
                DataSource ds = (DataSource)this.attachments.get(cid);
                DataHandler dh = new DataHandler(ds);
                AttachmentPart p = new AttachmentPart(dh);
                if (cid != null) {
                    p.setContentId(cid);
                }
                call.addAttachmentPart((Object)p);
            }
            this.attachments.clear();
        }
        return (String)call.invoke(param);
    }

    public final void createPage(String gdf) throws Exception {
        this.invoke("createPage", new Object[]{gdf});
    }

    public final String getPage(String id) throws Exception {
        return this.invoke("getPage", new Object[]{id});
    }

    public final void updatePage(String id, String gdf) throws Exception {
        this.invoke("updatePage", new Object[]{id, gdf});
    }

    public final void createFile(String gdf) throws Exception {
        this.invoke("createFile", new Object[]{gdf});
    }
}

