/*
 * Decompiled with CFR 0.152.
 */
package is.hugvit.bird;

import is.hugvit.bird.BirdDatabase;
import is.hugvit.bird.BirdException;
import is.hugvit.bird.BirdFactory;
import is.hugvit.bird.BirdFile;
import is.hugvit.bird.BirdPage;
import is.hugvit.bird.BirdSession;
import is.hugvit.gdf.Document;
import is.hugvit.gdf.GDF;
import is.hugvit.util.PropertiesEx;
import is.hugvit.util.UID;
import is.hugvit.util.Util;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URL;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.xml.soap.AttachmentPart;
import org.apache.axis.MessageContext;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.xml.sax.InputSource;

public final class BirdService {
    private static final String MSG_PAGE_NOT_FOUND = "Page not found";

    private static final void correctDoc(Document doc) {
        String s = doc.getString("gpw:type");
        if (s != null) {
            PropertiesEx p = new PropertiesEx();
            p.load(s, ";");
            doc.put("location", p.get("location"));
            doc.put("pagetype", p.get("pagetype"));
        }
        String subject = doc.getString("subject");
        doc.put("title", subject);
    }

    private static final void correctLinks(Element root, String attr, HashMap files) {
        if (files != null) {
            for (Element e : root.selectNodes("//*[@" + attr + ']')) {
                String cid;
                Object[] a;
                String href = e.attributeValue(attr);
                if (!href.startsWith("cid:") || (a = (Object[])files.get(cid = href.substring(4))) == null) continue;
                String name = (String)a[1];
                String filename = (String)a[2];
                href = "files/" + name + '/' + filename;
                e.addAttribute(attr, href);
            }
        }
    }

    private static final String getHTML(Element root, String name, HashMap files) {
        Element e = (Element)root.selectSingleNode("item[@name='" + name + "']/html");
        if (e != null) {
            StringBuffer s = new StringBuffer(4096);
            BirdService.correctLinks(root, "href", files);
            BirdService.correctLinks(root, "src", files);
            Iterator i = e.nodeIterator();
            while (i.hasNext()) {
                Node f = (Node)i.next();
                s.append(f.asXML());
            }
            return s.toString();
        }
        return null;
    }

    private static final void addAttachments(HashMap files, MessageContext ctx) throws Exception {
        Iterator i = ctx.getMessage().getAttachments();
        while (i.hasNext()) {
            AttachmentPart ap = (AttachmentPart)i.next();
            String cid = ap.getContentId();
            Object[] a = new Object[]{cid, null, null, null, ap};
            files.put(cid, a);
        }
    }

    private static final void addAttachments(HashMap files, Element root) throws Exception {
        Iterator i1 = root.elementIterator("document");
        while (i1.hasNext()) {
            Element doc = (Element)i1.next();
            Iterator i2 = doc.elementIterator("attachment");
            while (i2.hasNext()) {
                Element att = (Element)i2.next();
                String cid = att.attributeValue("cid");
                String name = att.attributeValue("name");
                String filename = att.attributeValue("filename");
                String url = att.attributeValue("url");
                Object[] a = null;
                if (cid != null) {
                    a = (Object[])files.get(cid);
                }
                if (a == null) {
                    a = new Object[5];
                    a[4] = null;
                    files.put(cid, a);
                }
                if (cid != null) {
                    a[0] = cid;
                }
                if (name == null) {
                    name = UID.getUID();
                }
                a[1] = name;
                if (filename != null) {
                    a[2] = filename;
                }
                if (url == null) continue;
                a[3] = url;
            }
        }
    }

    private static final void createFiles(HashMap files, BirdDatabase db) throws Exception {
        for (Object[] a : files.values()) {
            InputStream in = null;
            String cid = (String)a[0];
            String name = (String)a[1];
            String filename = (String)a[2];
            String url = (String)a[3];
            Object obj = a[4];
            if (obj != null) {
                if (obj instanceof InputStream) {
                    in = (InputStream)obj;
                } else {
                    AttachmentPart ap = (AttachmentPart)obj;
                    DataHandler dh = ap.getDataHandler();
                    DataSource ds = dh.getDataSource();
                    in = ds.getInputStream();
                }
            } else if (url != null) {
                URL u = new URL(url);
                if (filename == null) {
                    filename = Util.getFilename(u);
                }
                in = u.openStream();
            }
            if (in == null) continue;
            BirdFile f = db.createFile();
            if (name != null) {
                f.setName(name);
            }
            if (filename == null) {
                filename = cid;
            }
            f.setFilename(filename);
            f.setBody(in);
            f.save();
            in.close();
            a[1] = f.getName();
            a[2] = f.getFilename();
            System.out.println("BirdService:Creating file:name=" + name + ":filename=" + filename);
        }
    }

    private static final void checkEnabled() throws BirdException {
        BirdSession session = BirdFactory.createSession();
        Boolean b = (Boolean)session.getConfig().get("webservice");
        if (!b.booleanValue()) {
            throw new BirdException("WebService is disabled");
        }
    }

    public final void createFile(String gdf) throws Exception {
        BirdService.checkEnabled();
        try {
            MessageContext ctx = MessageContext.getCurrentContext();
            BirdSession session = BirdFactory.createSession();
            BirdDatabase db = session.getDatabase();
            StringReader r = new StringReader(gdf);
            SAXReader reader = new SAXReader();
            InputSource is = new InputSource(r);
            org.dom4j.Document document = reader.read(is);
            Element root = document.getRootElement();
            HashMap att = new HashMap();
            BirdService.addAttachments(att, ctx);
            BirdService.addAttachments(att, root);
            BirdService.createFiles(att, db);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public final void createPage(String gdf) throws Exception {
        System.out.println("BirdService.createPage");
        BirdService.checkEnabled();
        try {
            MessageContext ctx = MessageContext.getCurrentContext();
            BirdSession session = BirdFactory.createSession();
            BirdDatabase db = session.getDatabase();
            StringReader r = new StringReader(gdf);
            SAXReader reader = new SAXReader();
            InputSource is = new InputSource(r);
            org.dom4j.Document document = reader.read(is);
            Element root = document.getRootElement();
            HashMap att = new HashMap();
            BirdService.addAttachments(att, ctx);
            BirdService.addAttachments(att, root);
            BirdService.createFiles(att, db);
            Iterator i = root.elementIterator("document");
            while (i.hasNext()) {
                Element doc = (Element)i.next();
                Document d = new Document();
                d.put(doc);
                String type = d.getString("gpw:format");
                if (type != null && type.equals("pdf")) continue;
                BirdService.correctDoc(d);
                BirdPage page = db.createPage();
                Hashtable h = d.getHashtable();
                h.remove("type");
                h.remove("status");
                page.put(h);
                String body = BirdService.getHTML(doc, "body", att);
                if (body != null) {
                    page.setBody(body);
                }
                page.save();
                System.out.println("BirdService:Creating page:" + page.getTitle());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public final void updatePage(String id, String gdf) throws Exception {
        BirdService.checkEnabled();
        try {
            MessageContext ctx = MessageContext.getCurrentContext();
            BirdSession session = BirdFactory.createSession();
            BirdDatabase db = session.getDatabase();
            StringReader r = new StringReader(gdf);
            SAXReader reader = new SAXReader();
            InputSource is = new InputSource(r);
            org.dom4j.Document document = reader.read(is);
            Element root = document.getRootElement();
            Element doc = root.element("document");
            HashMap att = new HashMap();
            BirdService.addAttachments(att, ctx);
            BirdService.addAttachments(att, root);
            BirdService.createFiles(att, db);
            BirdPage page = db.getPageByExternalID(id);
            if (page == null) {
                throw new BirdException(MSG_PAGE_NOT_FOUND);
            }
            Document d = new Document();
            d.put(doc);
            page.put(d.getHashtable());
            String body = BirdService.getHTML(doc, "body", null);
            if (body != null) {
                page.setBody(body);
            }
            page.save();
            System.out.println("Updating page: " + id);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public final String getPage(String id) throws Exception {
        BirdService.checkEnabled();
        try {
            BirdSession session = BirdFactory.createSession();
            BirdDatabase db = session.getDatabase();
            BirdPage page = db.getPageByExternalID(id, true);
            if (page == null) {
                throw new BirdException(MSG_PAGE_NOT_FOUND);
            }
            GDF gdf = new GDF();
            Document doc = new Document();
            gdf.add(doc);
            doc.put(page.getHashtable());
            System.out.println("GetPage:" + page.getHashtable());
            return gdf.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }
}

