/*
 * Decompiled with CFR 0.152.
 */
package is.hugvit.bird;

import is.hugvit.bird.BirdBaseObject;
import is.hugvit.bird.BirdDatabase;
import is.hugvit.bird.BirdException;
import is.hugvit.bird.WebContextImpl;
import is.hugvit.bird.core.BirdUtil;
import is.hugvit.util.ArrayListEx;
import is.hugvit.util.HashMapEx;
import is.hugvit.util.UID;
import is.hugvit.util.Util;
import is.hugvit.xml.HtmlConverter;
import java.io.StringReader;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;

public final class BirdPage
extends BirdBaseObject {
    String role;

    BirdPage(BirdDatabase db, boolean is_new) throws BirdException {
        super(db);
        this.is_new = is_new;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BirdPage(BirdDatabase db, String pagetype) throws BirdException {
        super(db);
        this.is_new = true;
        this.h.put("pagetype", pagetype);
        try (Connection dc = db.connect();){
            PreparedStatement stmt = dc.prepareStatement("select lists,lifetime,folder from bird_pagetype where name=?");
            stmt.setString(1, pagetype);
            ResultSet rd = stmt.executeQuery();
            if (rd.next()) {
                String folder;
                this.h.put("lists", Util.split(rd.getString(1), ";"));
                int lifetime = rd.getInt(2);
                if (lifetime != 0) {
                    Calendar c = Calendar.getInstance();
                    c.add(5, lifetime);
                    this.h.put("enddate", c.getTime());
                }
                if ((folder = rd.getString(3)) == null) {
                    folder = "";
                }
                this.h.put("folder", folder);
            }
            rd.close();
            stmt.close();
        }
        catch (SQLException e) {
            throw new BirdException(e);
        }
    }

    private static final void checkAccess(WebContextImpl context, String roles) throws BirdException {
        if (context != null && roles != null && !roles.equals("")) {
            String[] s = Util.splitArray(roles, ";");
            for (int i = 0; i < s.length; ++i) {
                String r = s[i];
                if (context.isUserInRole(r)) continue;
                throw new BirdException("No Access");
            }
        }
    }

    public final void setTitle(String value) {
        this.h.put("title", value);
    }

    public final String getTitle() {
        return (String)this.h.get("title");
    }

    public final void setLanguage(String value) {
        this.h.put("lang", value);
    }

    public final String getLanguage() {
        return (String)this.h.get("lang");
    }

    public final String getFolder() {
        return (String)this.h.get("folder");
    }

    public final String getBody() {
        return (String)this.h.get("body");
    }

    public final void setBody(String s) {
        this.h.put("body", s);
    }

    public final void setFolder(String s) {
        this.h.put("folder", s);
    }

    public final void setDescription(String s) {
        this.h.put("description", s);
    }

    public final void setPageType(String value) {
        this.h.put("pagetype", value);
    }

    public final String getPageType() {
        return (String)this.h.get("pagetype");
    }

    public final String getName() {
        return (String)this.h.get("name");
    }

    public final Vector getWebRole() {
        Vector v;
        Object obj = this.h.get("webrole");
        if (obj == null) {
            v = new Vector();
        } else if (obj instanceof Vector) {
            v = (Vector)obj;
        } else {
            v = new Vector();
            v.addElement(obj);
        }
        return v;
    }

    public final String getRole() {
        return this.role;
    }

    public final void setName(String name) {
        this.h.put("name", name);
    }

    public final void setVisible(boolean visible) {
        this.h.put("visible", visible ? "1" : "0");
    }

    public final void setTypeFolder() {
        this.h.put("type", "FOLDER");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List getAllRoles() throws BirdException {
        try {
            HashMapEx map = new HashMapEx();
            try (Connection dc = this.db.connect();){
                String folder = (String)this.h.get("folder");
                PreparedStatement stmt = dc.prepareStatement("select folder,role from bird_page where id=?");
                while (!folder.equals("")) {
                    stmt.setString(1, folder);
                    try (ResultSet rs = stmt.executeQuery();){
                        if (!rs.next()) break;
                        folder = rs.getString(1);
                        map.putStrings(rs.getString(2));
                    }
                }
                stmt.close();
            }
            return new ArrayListEx(map);
        }
        catch (SQLException e) {
            throw new BirdException(e);
        }
    }

    public final void setExternalID(String id) {
        this.h.put("extid", id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final void setSort(Connection c, Hashtable h) throws SQLException {
        int count = 0;
        String folder = (String)h.get("folder");
        try (PreparedStatement stmt = c.prepareStatement("select max(sort) from bird_page where folder=?");){
            stmt.setString(1, folder);
            try (ResultSet rs = stmt.executeQuery();){
                if (rs.next()) {
                    count = rs.getInt(1) + 1;
                }
            }
        }
        h.put("sort", new Integer(count));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void checkFolderSort(Connection c, Hashtable h) throws SQLException {
        String id = (String)h.get("id");
        String folder = (String)h.get("folder");
        String oldfolder = "";
        try (PreparedStatement stmt = c.prepareStatement("select folder from bird_page where id=?");){
            stmt.setString(1, id);
            try (ResultSet rs = stmt.executeQuery();){
                if (rs.next()) {
                    oldfolder = rs.getString(1);
                }
            }
        }
        if (!oldfolder.equals(folder)) {
            BirdPage.setSort(c, h);
        }
    }

    private static final void setPageName(Connection c, Hashtable h) throws SQLException {
        ResultSet rs;
        PreparedStatement stmt;
        String pattern = "page%.html";
        String pagetype = (String)h.get("pagetype");
        if (pagetype != null && !pagetype.equals("")) {
            String seqname;
            stmt = c.prepareStatement("select seqname from bird_pagetype where name=?");
            stmt.setString(1, pagetype);
            rs = stmt.executeQuery();
            if (rs.next() && (seqname = rs.getString(1)) != null && !seqname.equals("")) {
                pattern = seqname.replace('?', '%').toLowerCase();
            }
            rs.close();
            stmt.close();
        }
        if (pattern.indexOf(37) == -1) {
            pattern = pattern + "%.html";
        }
        stmt = c.prepareStatement("select name from bird_page where type='PAGE' and name like ?");
        stmt.setString(1, pattern);
        rs = stmt.executeQuery();
        int max = 0;
        while (rs.next()) {
            int j = Util.getInt(rs.getString(1));
            if (j <= max) continue;
            max = j;
        }
        rs.close();
        stmt.close();
        String name = Util.replace(pattern, "%", ++max + "");
        h.put("name", name);
    }

    public void delete() throws BirdException {
        this.delete("bird_page");
        this.db.engine.cache.invalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String createFolderStructure(Connection c, BirdDatabase db, String folder) throws BirdException, SQLException {
        String id = "";
        StringTokenizer st = new StringTokenizer(folder, "\\");
        try (PreparedStatement stmt = c.prepareStatement("select id from bird_page where type='FOLDER' and folder=? and title=?");){
            while (st.hasMoreTokens()) {
                String title = st.nextToken();
                stmt.setString(1, id);
                stmt.setString(2, title);
                try (ResultSet rs = stmt.executeQuery();){
                    if (rs.next()) {
                        id = rs.getString(1);
                        continue;
                    }
                    BirdPage p = db.createPage();
                    p.put("type", "FOLDER");
                    p.put("folder", id);
                    p.setTitle(title);
                    p.save();
                    id = p.getID();
                }
            }
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void save() throws BirdException {
        try (Connection c = this.db.connect();){
            Vector<Object> v;
            Object obj;
            String type;
            String location = (String)this.h.get("location");
            if (location != null) {
                this.h.remove("location");
                String id = BirdPage.createFolderStructure(c, this.db, location);
                this.h.put("folder", id);
            }
            this.h.put("modified", new Timestamp(System.currentTimeMillis()));
            if (this.db.context != null) {
                String user = this.db.context.getRequest().getRemoteUser();
                if (user == null) {
                    user = "";
                }
                this.h.put("modified_by", user);
            }
            if (this.h.containsKey("body")) {
                try {
                    HtmlConverter hc = new HtmlConverter();
                    hc.setTextOnly(true);
                    String body = (String)this.h.get("body");
                    StringReader in = new StringReader(body);
                    StringWriter out = new StringWriter(body.length());
                    hc.parse(in, out);
                    this.h.put("textbody", out.toString());
                }
                catch (Exception hc) {
                    // empty catch block
                }
            }
            if (this.is_new) {
                if (!this.h.containsKey("id")) {
                    this.h.put("id", UID.getUID());
                }
                if (!this.h.containsKey("role")) {
                    this.h.put("role", "");
                }
                if (!this.h.containsKey("type")) {
                    this.h.put("type", "PAGE");
                }
                if (!this.h.containsKey("status")) {
                    this.h.put("status", "APPROVED");
                }
                if (!this.h.containsKey("folder")) {
                    this.h.put("folder", "");
                }
                if (!this.h.containsKey("pagedate")) {
                    this.h.put("pagedate", new Date());
                }
                if (!this.h.containsKey("visible")) {
                    this.h.put("visible", "1");
                }
                if (!this.h.containsKey("lang")) {
                    this.h.put("lang", this.db.engine.getLocale().getLanguage());
                }
                BirdPage.setSort(c, this.h);
            } else {
                BirdPage.checkFolderSort(c, this.h);
            }
            String name = (String)this.h.get("name");
            if (name == null) {
                name = "";
                this.h.put("name", "");
            }
            if ((type = (String)this.h.get("type")) == null) {
                type = "";
            }
            if ((name = name.toLowerCase()).equals("") && type.equals("PAGE")) {
                BirdPage.setPageName(c, this.h);
            }
            if ((obj = this.h.get("lists")) instanceof String) {
                v = new Vector<Object>();
                v.addElement(obj);
            } else {
                v = (Vector<Object>)obj;
            }
            if (v == null) {
                v = new Vector();
            }
            v.addElement("");
            this.h.put("lists", v);
            if (type.equals("PAGE")) {
                BirdUtil.updateRole(c, "webrole", this.h);
            }
            this.h.retainAll(BirdDatabase.page_fields);
            if (this.is_new) {
                BirdUtil.insert(c, "bird_page", this.h);
            } else {
                Hashtable key = new Hashtable();
                key.put("id", this.h.get("id"));
                BirdUtil.update(c, "bird_page", this.h, key);
                this.db.engine.cache.invalidate();
            }
        }
        catch (SQLException e) {
            throw new BirdException(e);
        }
    }
}

