/*
 * Decompiled with CFR 0.152.
 */
package is.hugvit.bird;

import is.hugvit.bird.FileInfo;
import is.hugvit.bird.PageXSL;
import is.hugvit.bird.WebContextImpl;
import is.hugvit.bird.WebElementData;
import is.hugvit.util.Cache;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;

final class BirdCache {
    private final HashMap element_cache = new HashMap(500);
    final Cache xsl_cache = new Cache(50);
    final Cache file_cache = new Cache(500);

    BirdCache() {
    }

    final PageXSL getPageByName(String pagename) {
        return (PageXSL)this.xsl_cache.get(pagename);
    }

    final void putPage(PageXSL page) {
        this.xsl_cache.put(page.getPageName(), page);
    }

    final void putFileInfo(FileInfo f) {
        this.file_cache.put(f.name, f);
    }

    final void putElement(WebElementData wed) {
        this.element_cache.put(wed.name, wed);
    }

    final FileInfo getFileInfo(String name) {
        return (FileInfo)this.file_cache.get(name);
    }

    final WebElementData getElement(String name) {
        return (WebElementData)this.element_cache.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final String getPageNameByAlias(WebContextImpl wc, String alias) {
        Iterator e = this.xsl_cache.iterator();
        while (e.hasNext()) {
            PageXSL page = (PageXSL)e.next();
            if (!page.getAlias().equals(alias)) continue;
            return page.getPageName();
        }
        String pagename = null;
        try {
            Connection dc = wc.getConnection();
            try (PreparedStatement stmt = dc.prepareStatement("select name from bird_page where alias=?");){
                stmt.setString(1, alias);
                try (ResultSet rs = stmt.executeQuery();){
                    if (rs.next()) {
                        pagename = rs.getString(1);
                    }
                }
            }
        }
        catch (SQLException ex) {
            wc.engine.log.error(ex);
        }
        return pagename;
    }

    final void invalidate() {
        this.xsl_cache.clear();
        this.file_cache.clear();
        this.element_cache.clear();
    }

    final void invalidate_files() {
        this.file_cache.clear();
    }
}

