<xsl:template name="bird_replace">
   <xsl:param name="string" />
   <xsl:param name="from" select="'&#xA;'" />
   <xsl:param name="to">
      <br />
   </xsl:param>
   <xsl:choose>
      <xsl:when test="contains($string, $from)">
         <xsl:value-of select="substring-before($string, $from)" />
         <xsl:copy-of select="$to" />
         <xsl:call-template name="bird_replace">
            <xsl:with-param name="string"
                            select="substring-after($string, $from)" />
            <xsl:with-param name="from" select="$from" />
            <xsl:with-param name="to" select="$to" />
         </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
         <xsl:value-of select="$string" />
      </xsl:otherwise>
   </xsl:choose>
</xsl:template>

<xsl:template name="bird_lowercase">
  <xsl:param name="string" select="''"/>
  <xsl:value-of select="translate($string,'ABCDEFGHIJKLMNOPQRSTUVWXYZ','abcdefghijklmnopqrstuvwxyz')"/>
</xsl:template>

<xsl:template name="bird_escape_javascript">
<xsl:param name="string"/>
<xsl:choose>
    <xsl:when test='contains($string, "&apos;")'>
      <xsl:call-template name="bird_escape_javascript">
        <xsl:with-param select='substring-before($string, "&apos;")' name="string"/>
      </xsl:call-template>
      <xsl:text>\'</xsl:text>
      <xsl:call-template name="bird_escape_javascript">
        <xsl:with-param select='substring-after($string, "&apos;")' name="string"/>
      </xsl:call-template>
    </xsl:when>
    <xsl:when test="contains($string, '&quot;')">
      <xsl:call-template name="bird_escape_javascript">
        <xsl:with-param select="substring-before($string, '&quot;')" name="string"/>
      </xsl:call-template>
      <xsl:text>\"</xsl:text>
      <xsl:call-template name="bird_escape_javascript">
        <xsl:with-param select="substring-after($string,'&quot;')" name="string"/>
      </xsl:call-template>
    </xsl:when>
    <xsl:when test="contains($string, '&#xA;')">
      <xsl:call-template name="bird_escape_javascript">
        <xsl:with-param select="substring-before($string, '&#xA;')" name="string"/>
      </xsl:call-template>
      <xsl:text>\n</xsl:text>
      <xsl:call-template name="bird_escape_javascript">
        <xsl:with-param select="substring-after($string, '&#xA;')" name="string"/>
      </xsl:call-template>
    </xsl:when>
    <xsl:when test="contains($string, '\')">
      <xsl:value-of select="substring-before($string, '\')"/>
      <xsl:text>\\</xsl:text>
      <xsl:call-template name="bird_escape_javascript">
        <xsl:with-param select="substring-after($string, '\')" name="string"/>
      </xsl:call-template>
    </xsl:when>
   <xsl:otherwise><xsl:value-of select="$string"/></xsl:otherwise>
</xsl:choose>
</xsl:template>

