/*
 * Decompiled with CFR 0.152.
 */
package is.hugvit.bird.client;

import is.hugvit.bird.BirdDatabase;
import is.hugvit.bird.BirdException;
import is.hugvit.bird.Field;
import is.hugvit.bird.Form;
import is.hugvit.bird.WebContext;
import is.hugvit.bird.core.WebBirdForm;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;

public final class WebTemplate
extends WebBirdForm {
    public WebTemplate() {
        this.setTable("bird_template");
        this.setRedirect("bird:templates");
        this.add(new Field("name", true));
        this.add(new Field("type"));
        this.add(new Field("body"));
    }

    public final boolean querySave(WebContext context, Form data) throws BirdException {
        if (!super.querySave(context, data)) {
            return false;
        }
        try {
            String body = data.getString("body");
            StringBuffer s = new StringBuffer(body.length() + 256);
            s.append("<!DOCTYPE stylesheet [");
            s.append("<!ENTITY nbsp \"&#160;\">");
            s.append("]>");
            s.append("<bird_root");
            s.append(" xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\"");
            s.append(" xmlns:bird=\"http://www.hugvit.is/bird\"");
            s.append('>');
            s.append(body);
            s.append("</bird_root>");
            DocumentHelper.parseText((String)s.toString());
        }
        catch (DocumentException e) {
            String msg = e.getMessage();
            Throwable t = e.getNestedException();
            if (t != null) {
                msg = t.getMessage();
            }
            data.setMessage(msg);
            return false;
        }
        return true;
    }

    public final void doDelete(WebContext context, Form data) throws BirdException {
        super.doDelete(context, data);
        BirdDatabase db = context.getSession().getDatabase();
        db.clearCache();
    }

    public final void doSave(WebContext context, Form data) throws BirdException {
        boolean open = data.getBoolean("_open");
        super.doSave(context, data);
        BirdDatabase db = context.getSession().getDatabase();
        db.clearCache();
        if (open) {
            context.setRedirectPage("bird:template", "edit&id=" + data.getID());
        }
    }
}

