/*
 * Decompiled with CFR 0.152.
 */
package is.hugvit.bird.client;

import is.hugvit.bird.BirdDatabase;
import is.hugvit.bird.BirdException;
import is.hugvit.bird.Field;
import is.hugvit.bird.Form;
import is.hugvit.bird.WebContext;
import is.hugvit.bird.client.WebEditPage;
import is.hugvit.bird.core.WebBirdForm;
import is.hugvit.bird.core.WebMenuEdit;
import is.hugvit.util.Util;
import is.hugvit.xml.HtmlConverter;
import is.hugvit.xml.ParseException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.dom4j.Element;

public final class WebPageType
extends WebBirdForm {
    public WebPageType() {
        this.setTable("bird_pagetype");
        this.setRedirect("bird:pagetypes");
        this.add(new Field("name", true));
        this.add(new Field("head"));
        this.add(new Field("body"));
        this.add(new Field("templates", 5));
        this.add(new Field("elements", 5));
        this.add(new Field("lists", 5));
        this.add(new Field("lifetime", 1));
        this.add(new Field("seqname"));
        this.add(new Field("folder"));
        this.add(new Field("role"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final void addElementsXML(WebContext context) throws BirdException {
        try {
            Connection dc = (Connection)context.getAttribute("bird.connection");
            Element root = context.getRootElement();
            Element elements = root.addElement("bird_elements");
            PreparedStatement stmt = dc.prepareStatement("select name,role from bird_element where (isprivate is null or isprivate='0') order by name");
            ResultSet rd = stmt.executeQuery();
            try {
                while (rd.next()) {
                    String name = rd.getString(1);
                    String role = rd.getString(2);
                    if (role == null) {
                        role = "";
                    }
                    if (!role.equals("") && !context.isUserInRole(role)) continue;
                    elements.addElement("name").addText(name);
                }
            }
            finally {
                rd.close();
                stmt.close();
            }
        }
        catch (SQLException e) {
            throw new BirdException((Exception)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final void addTemplatesXML(WebContext context) throws BirdException {
        try {
            Connection dc = (Connection)context.getAttribute("bird.connection");
            Element root = context.getRootElement();
            Element templates = root.addElement("bird_templates");
            PreparedStatement stmt = dc.prepareStatement("select name,role from bird_template where (isprivate is null or isprivate='0') order by name");
            ResultSet rd = stmt.executeQuery();
            try {
                while (rd.next()) {
                    String name = rd.getString(1);
                    String role = rd.getString(2);
                    if (role == null) {
                        role = "";
                    }
                    if (!role.equals("") && !context.isUserInRole(role)) continue;
                    templates.addElement("name").addText(name);
                }
            }
            finally {
                rd.close();
                stmt.close();
            }
        }
        catch (SQLException e) {
            throw new BirdException((Exception)e);
        }
    }

    protected final void doXML(WebContext context, Form data) throws BirdException {
        super.doXML(context, data);
        Element root = context.getRootElement();
        WebPageType.addElementsXML(context);
        WebPageType.addTemplatesXML(context);
        WebMenuEdit.doRoles((WebContext)context);
        Connection dc = (Connection)context.getAttribute("bird.connection");
        WebEditPage.doFolders(context, dc, root.addElement("bird_folders"), "", "");
    }

    public final boolean queryOpen(WebContext context, Form data) throws BirdException {
        super.queryOpen(context, data);
        try {
            if (data.isCreate()) {
                data.put("body", Util.getResourceString((Object)((Object)this), (String)"files/body.html"));
            }
            return true;
        }
        catch (IOException e) {
            throw new BirdException((Exception)e);
        }
    }

    public final boolean querySave(WebContext context, Form data) throws BirdException {
        if (!super.querySave(context, data)) {
            return false;
        }
        try {
            String head = data.getString("head");
            HtmlConverter h = new HtmlConverter();
            StringReader in = new StringReader(head);
            StringWriter out = new StringWriter(head.length());
            h.parse((Reader)in, (Writer)out);
            data.put("head", out.toString());
            String body = data.getString("body");
            in = new StringReader(body);
            out = new StringWriter(body.length());
            h.parse((Reader)in, (Writer)out);
            data.put("body", out.toString());
            return true;
        }
        catch (ParseException e) {
            data.setMessage(e.getDetailedMessage());
            return false;
        }
        catch (IOException e) {
            throw new BirdException((Exception)e);
        }
    }

    public final void doDelete(WebContext context, Form data) throws BirdException {
        super.doDelete(context, data);
        BirdDatabase db = context.getSession().getDatabase();
        db.clearCache();
    }

    public final void doSave(WebContext context, Form data) throws BirdException {
        super.doSave(context, data);
        BirdDatabase db = context.getSession().getDatabase();
        db.clearCache();
    }
}

