/*
 * Decompiled with CFR 0.152.
 */
package is.hugvit.bird.client;

import is.hugvit.bird.BirdDatabase;
import is.hugvit.bird.BirdException;
import is.hugvit.bird.Field;
import is.hugvit.bird.Form;
import is.hugvit.bird.WebContext;
import is.hugvit.bird.WebElement;
import is.hugvit.bird.core.WebBirdForm;
import is.hugvit.util.Util;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Element;

public final class WebNewElement
extends WebBirdForm {
    private static final List elements = new ArrayList();

    public WebNewElement() {
        this.setTable("bird_element");
        this.setRedirect("bird:elements");
        this.add(new Field("name", true));
        this.add(new Field("classname", true));
    }

    protected void doXML(WebContext context, Form data) throws BirdException {
        super.doXML(context, data);
        Element root = context.getRootElement();
        Element es = root.addElement("elements");
        for (String name : elements) {
            String value = "is.hugvit.bird.Web" + name;
            Element e = es.addElement("element");
            e.addElement("name").addText(name);
            e.addElement("value").addText(value);
            try {
                WebElement el = (WebElement)Class.forName(value).newInstance();
                String desc = el.getDescription();
                e.addElement("description").addText(desc);
                e.addElement("description_encoded").addText(Util.escapeMarkupAttribute((String)desc));
            }
            catch (Exception exception) {}
        }
    }

    public final boolean queryOpen(WebContext context, Form data) throws BirdException {
        data.put("classname", "is.hugvit.bird.Web" + elements.get(0));
        return super.queryOpen(context, data);
    }

    public final boolean querySave(WebContext context, Form data) throws BirdException {
        if (!super.querySave(context, data)) {
            return false;
        }
        String classname = data.getString("classname");
        try {
            Class.forName(classname).newInstance();
        }
        catch (Exception e) {
            data.setError("classname");
            return false;
        }
        return true;
    }

    public final void doDelete(WebContext context, Form data) throws BirdException {
        super.doDelete(context, data);
        BirdDatabase db = context.getSession().getDatabase();
        db.clearCache();
    }

    public final void doSave(WebContext context, Form data) throws BirdException {
        data.remove("type");
        super.doSave(context, data);
        BirdDatabase db = context.getSession().getDatabase();
        db.clearCache();
    }

    static {
        elements.add("DateInfo");
        elements.add("Error");
        elements.add("List");
        elements.add("Menu");
        elements.add("NotesSession");
        elements.add("NotesView");
        elements.add("PageIndex");
        elements.add("PageInfo");
        elements.add("QueryString");
        elements.add("RSS");
        elements.add("Search");
        elements.add("Server");
        elements.add("SQLForm");
        elements.add("SQLQuery");
        elements.add("User");
    }
}

