/*
 * Decompiled with CFR 0.152.
 */
package is.hugvit.bird.client;

import is.hugvit.bird.BirdException;
import is.hugvit.bird.WebContext;
import is.hugvit.bird.WebElementBase;
import is.hugvit.net.QueryString;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import javax.servlet.http.HttpServletRequest;

public final class WebMove
extends WebElementBase {
    private static final int callFunc(Connection c, String func, String folder) throws SQLException {
        int i = 0;
        PreparedStatement pstmt = c.prepareStatement("select " + func + "(sort) from bird_page where folder=?");
        pstmt.setString(1, folder);
        ResultSet rs = pstmt.executeQuery();
        if (rs.next()) {
            i = rs.getInt(1);
        }
        rs.close();
        pstmt.close();
        return i;
    }

    private static final void updatePage(WebContext context, String id, int sort) throws SQLException, BirdException {
        Connection c = (Connection)context.getAttribute("bird.connection");
        HttpServletRequest req = context.getRequest();
        PreparedStatement pstmt = c.prepareStatement("update bird_page set sort=?,modified=?,modified_by=? where id=?");
        pstmt.setInt(1, sort);
        pstmt.setTimestamp(2, new Timestamp(System.currentTimeMillis()));
        pstmt.setString(3, req.getRemoteUser());
        pstmt.setString(4, id);
        pstmt.executeUpdate();
        pstmt.close();
    }

    public void doGet(WebContext context) throws BirdException {
        try {
            Connection c = (Connection)context.getAttribute("bird.connection");
            HttpServletRequest req = context.getRequest();
            QueryString qs = new QueryString(req.getQueryString());
            String dir = qs.get("dir");
            String id = qs.get("id");
            PreparedStatement pstmt = c.prepareStatement("select folder,sort from bird_page where id=?");
            pstmt.setString(1, id);
            ResultSet rs = pstmt.executeQuery();
            if (!rs.next()) {
                context.setRedirectPage("bird:pages");
                return;
            }
            String folder = rs.getString(1);
            int sort = rs.getInt(2);
            rs.close();
            pstmt.close();
            context.setRedirectPage("bird:pages", "id=" + folder);
            if (dir.equals("top")) {
                int x = WebMove.callFunc(c, "min", folder);
                if (x == sort) {
                    return;
                }
                sort = x - 1;
            } else if (dir.equals("bottom")) {
                int x = WebMove.callFunc(c, "max", folder);
                if (x == sort) {
                    return;
                }
                sort = x + 1;
            } else {
                String order = "asc";
                if (dir.equals("down")) {
                    order = "desc";
                }
                pstmt = c.prepareStatement("select role,id,sort from bird_page where folder=? and (isprivate is null or isprivate='0') order by sort " + order);
                pstmt.setString(1, folder);
                String prev_id = "";
                int prev_sort = 0;
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    String role = rs.getString(1);
                    if (role != null && !role.equals("") && !context.isUserInRole(role)) continue;
                    String curr_id = rs.getString(2);
                    int curr_sort = rs.getInt(3);
                    if (curr_id.equals(id)) {
                        if (prev_id.equals("")) {
                            return;
                        }
                        WebMove.updatePage(context, prev_id, curr_sort);
                        sort = prev_sort;
                        break;
                    }
                    prev_id = curr_id;
                    prev_sort = curr_sort;
                }
                rs.close();
                pstmt.close();
            }
            WebMove.updatePage(context, id, sort);
        }
        catch (SQLException e) {
            throw new BirdException((Exception)e);
        }
    }
}

