/*
 * Decompiled with CFR 0.152.
 */
package is.hugvit.bird.client;

import is.hugvit.bird.BirdDatabase;
import is.hugvit.bird.BirdException;
import is.hugvit.bird.Field;
import is.hugvit.bird.Form;
import is.hugvit.bird.WebContext;
import is.hugvit.bird.core.WebBirdForm;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import org.dom4j.Element;

public final class WebList
extends WebBirdForm {
    private static final Vector formats = new Vector();

    public WebList() {
        this.setTable("bird_list");
        this.setRedirect("bird:lists");
        this.add(new Field("name", true));
        this.add(new Field("type"));
        this.add(new Field("template"));
        this.add(new Field("sort"));
        this.add(new Field("direction"));
        this.add(new Field("showdesc", 2));
        this.add(new Field("showdate", 2));
        this.add(new Field("showbody", 2));
        this.add(new Field("dateformat"));
        this.add(new Field("datetype"));
    }

    protected final void doXML(WebContext context, Form data) throws BirdException {
        super.doXML(context, data);
        Element d = context.getRootElement().addElement("bird_dateformat");
        Date date = new Date();
        Enumeration e = formats.elements();
        while (e.hasMoreElements()) {
            String format = (String)e.nextElement();
            Element r = d.addElement("format");
            r.addElement("value").addText(format);
            SimpleDateFormat sf = new SimpleDateFormat(format);
            r.addElement("name").addText(sf.format(date));
        }
    }

    public final void doSave(WebContext context, Form data) throws BirdException {
        super.doSave(context, data);
        BirdDatabase db = context.getSession().getDatabase();
        db.clearCache();
    }

    static {
        formats.addElement("d.M.yyyy");
        formats.addElement("d. MMMM yyyy");
        formats.addElement("EEEE d. MMMM");
    }
}

