/*
 * Decompiled with CFR 0.152.
 */
package is.hugvit.bird.client;

import is.hugvit.bird.BirdDatabase;
import is.hugvit.bird.BirdException;
import is.hugvit.bird.BirdPage;
import is.hugvit.bird.Field;
import is.hugvit.bird.Form;
import is.hugvit.bird.WebContext;
import is.hugvit.bird.core.WebBirdForm;
import is.hugvit.net.QueryString;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public final class WebLink
extends WebBirdForm {
    public WebLink() {
        this.setTable("bird_page");
        this.setRedirect("bird:pages");
        this.add(new Field("title", true));
        this.add(new Field("folder"));
        this.add(new Field("name", true));
    }

    public final boolean queryOpen(WebContext context, Form data) throws BirdException {
        try {
            Connection dc = (Connection)context.getAttribute("bird.connection");
            super.queryOpen(context, data);
            if (data.isCreate()) {
                QueryString qs = new QueryString(context.getRequest().getQueryString());
                String pid = qs.get("parent");
                PreparedStatement stmt = dc.prepareStatement("select title from bird_page where id=?");
                stmt.setString(1, pid);
                ResultSet rs = stmt.executeQuery();
                if (rs.next()) {
                    data.put("folder", pid);
                    data.put("parent_title", rs.getString(1));
                    data.put("name", "http://");
                }
                rs.close();
                stmt.close();
            } else {
                if (data.getID().equals("")) {
                    context.setRedirectPage("bird:pages");
                    return false;
                }
                PreparedStatement stmt = dc.prepareStatement("select title from bird_page where id=?");
                stmt.setString(1, data.getString("folder"));
                ResultSet rs = stmt.executeQuery();
                if (rs.next()) {
                    data.put("parent_title", rs.getString(1));
                }
                rs.close();
                stmt.close();
            }
            return true;
        }
        catch (SQLException e) {
            throw new BirdException((Exception)e);
        }
    }

    public final void doSave(WebContext context, Form data) throws BirdException {
        data.remove("parent_title");
        BirdDatabase db = context.getSession().getDatabase();
        BirdPage page = data.isCreate() ? db.createPage() : db.getPageByID(data.getID());
        page.put(data.getHashtable());
        page.save();
        String folder = (String)page.get("folder");
        context.setRedirectPage("bird:pages", "id=" + folder);
    }
}

