/*
 * Decompiled with CFR 0.152.
 */
package is.hugvit.bird.client;

import is.hugvit.bird.BirdException;
import is.hugvit.bird.WebContext;
import is.hugvit.bird.WebElementBase;
import is.hugvit.bird.client.LinkComparator;
import is.hugvit.bird.client.WebFile;
import is.hugvit.bird.core.BirdUtil;
import is.hugvit.sql.SQLUtil;
import is.hugvit.util.HashMapEx;
import is.hugvit.util.Util;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;

public class WebJsEditor
extends WebElementBase {
    private static final String SQL_PAGES = "select title,name,role,id from bird_page where folder=? and type=? and (isprivate is null or isprivate='0') order by sort";
    private static String encoding = "UTF-8";
    private static final ArrayList<String> imageTypes = new ArrayList();

    public void doGet(WebContext context) throws BirdException {
        encoding = (String)context.getSession().getConfig().get("encoding");
        String param = context.getRequest().getParameter("js");
        String filter = context.getRequest().getParameter("filter");
        String format = context.getRequest().getParameter("format");
        if ("images".equals(param)) {
            this.writeImageScript(context, filter, format);
        } else if ("links".equals(param)) {
            this.writeLinksScript(context, format);
        }
    }

    private void writeLinksScript(WebContext context, String format) throws BirdException {
        Connection c = (Connection)context.getAttribute("bird.connection");
        Document doc = DocumentHelper.createDocument();
        Element el = doc.addElement("pages");
        try {
            int i;
            WebJsEditor.doItems(c, el, "", "");
            WebJsEditor.doFolders(context, c, el, "", "");
            Hashtable<String, String> h = new Hashtable<String, String>();
            List nodes = el.selectNodes("/pages/page");
            for (Node node : nodes) {
                h.put(node.selectSingleNode("title").getText(), node.selectSingleNode("name").getText());
            }
            nodes = el.selectNodes("/pages/group");
            for (Node node : nodes) {
                List subNodes = node.selectNodes("page");
                for (Node n : subNodes) {
                    h.put(n.selectSingleNode("title").getText(), n.selectSingleNode("name").getText());
                }
            }
            Vector v = new Vector(h.keySet());
            LinkComparator lc = new LinkComparator();
            Collections.sort(v, lc);
            HttpServletResponse res = context.getResponse();
            StringBuffer sb = new StringBuffer();
            if ("json".equals(format)) {
                res.setContentType("application/json; charset=" + encoding);
                sb.append("[\n");
                i = 0;
                Enumeration e = v.elements();
                while (e.hasMoreElements()) {
                    String linkKey = (String)e.nextElement();
                    String linkValue = (String)h.get(linkKey);
                    String entry = "{\"title\": \"" + linkKey + "\", \"value\": \"" + linkValue + "\"}";
                    if (i < h.size() - 1) {
                        entry = entry + ",";
                    }
                    sb.append(entry);
                    ++i;
                }
                sb.append("\n]");
            } else {
                res.setContentType("text/javascript; charset=" + encoding);
                sb.append("var tinyMCELinkList = new Array(");
                i = 0;
                Enumeration e = v.elements();
                while (e.hasMoreElements()) {
                    String hKey = (String)e.nextElement();
                    String hVal = (String)h.get(hKey);
                    String entry = "[\"" + hKey + "\", \"" + hVal + "\"]";
                    if (i < h.size() - 1) {
                        entry = entry + ",";
                    }
                    sb.append(entry);
                    ++i;
                }
                sb.append(");");
            }
            byte[] b = sb.toString().getBytes(encoding);
            res.setContentLength(b.length);
            res.getOutputStream().write(b);
            res.getOutputStream().flush();
            res.getOutputStream().close();
        }
        catch (Exception e) {
            throw new BirdException(e);
        }
    }

    private final boolean isValidImage(String filename) {
        String ext = Util.getFileExt((String)filename);
        return imageTypes.contains(ext.toLowerCase());
    }

    private List<Hashtable> filterImages(List<Hashtable> list, String filter) {
        ArrayList<Hashtable> imageList = new ArrayList<Hashtable>();
        int filterMin = 22;
        for (int i = 0; i < list.size(); ++i) {
            Hashtable h = list.get(i);
            String filename = (String)h.get("filename");
            if (filter != null && "guidance".equals(filter)) {
                Object wo = h.get("height");
                Object ho = h.get("width");
                if (wo instanceof Integer && ho instanceof Integer) {
                    Integer height = (Integer)ho;
                    Integer width = (Integer)wo;
                    if (height != null && width != null && (height >= filterMin || width >= filterMin)) continue;
                }
            }
            if (!this.isValidImage(filename)) continue;
            imageList.add(h);
        }
        return imageList;
    }

    private void writeImageScript(WebContext context, String filter, String format) throws BirdException {
        try {
            int i;
            StringBuffer sb = new StringBuffer();
            List<Hashtable> list = this.getImageData(context);
            list = this.filterImages(list, filter);
            HttpServletResponse res = context.getResponse();
            if ("json".equals(format)) {
                res.setContentType("application/json; charset=" + encoding);
                sb.append("[\n");
                for (i = 0; i < list.size(); ++i) {
                    Hashtable h = list.get(i);
                    String filename = (String)h.get("name");
                    String url = "files/" + filename + "/" + h.get("filename");
                    String jsonFilename = (String)h.get("filename");
                    String entry = "{\"title\": \"" + jsonFilename + "\", \"value\": \"" + url + "\"}";
                    if (i < list.size() - 1) {
                        entry = entry + ",";
                    }
                    sb.append(entry);
                }
                sb.append("\n]");
            } else {
                res.setContentType("text/javascript; charset=" + encoding);
                if (list.size() > 0) {
                    sb.append("var tinyMCEImageList = new Array(");
                    for (i = 0; i < list.size(); ++i) {
                        Hashtable h = list.get(i);
                        String filename = (String)h.get("name");
                        String url = "files/" + filename + "/" + h.get("filename");
                        String entry = "[\"" + h.get("filename") + "\",\"" + url + "\"]";
                        if (i < list.size() - 1) {
                            entry = entry + ",";
                        }
                        sb.append(entry);
                    }
                    sb.append(");");
                }
            }
            byte[] b = sb.toString().getBytes(encoding);
            res.setContentLength(b.length);
            res.getOutputStream().write(b);
            res.getOutputStream().flush();
            res.getOutputStream().close();
        }
        catch (Exception ex) {
            throw new BirdException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Hashtable> getImageData(WebContext context) throws BirdException {
        ArrayList<Hashtable> list = new ArrayList<Hashtable>();
        try {
            HttpServletRequest req = context.getRequest();
            Connection dc = (Connection)context.getAttribute("bird.connection");
            WebFile.addFileTypes(context);
            StringBuffer s = new StringBuffer("select isprivate,folder,id,name,filename,size,width,height,alt,pfilename,pwidth,pheight,type,description from bird_file");
            String folder_id = req.getParameter("folder");
            String type = "IMAGE";
            if (folder_id != null) {
                s.append(" where folder=?");
                type = context.getParameter("type", "");
                if (!type.equals("")) {
                    s.append(" and type=?");
                }
            }
            s.append(" order by name");
            PreparedStatement stmt = dc.prepareStatement(s.toString());
            stmt = dc.prepareStatement(s.toString());
            if (folder_id != null) {
                stmt.setString(1, folder_id);
                if (!type.equals("")) {
                    stmt.setString(2, type);
                }
            }
            ResultSet rd = stmt.executeQuery();
            try {
                while (rd.next()) {
                    HashMapEx hx;
                    String[] roles;
                    String folder;
                    Hashtable h = SQLUtil.getHashtable((ResultSet)rd);
                    if (h.get("isprivate").equals("1") && !context.isUserInRole("super_administrator") || !(folder = h.get("folder").toString()).equals("") && !context.isUserInAllRoles(roles = (hx = BirdUtil.getAllRolesForFolder((Connection)dc, (String)folder)).toStrings())) continue;
                    list.add(h);
                }
            }
            finally {
                rd.close();
                stmt.close();
            }
        }
        catch (SQLException e) {
            throw new BirdException((Exception)e);
        }
        return list;
    }

    private static final void doItems(Connection c, Element folder, String parent_id, String parent_name) throws SQLException {
        PreparedStatement pstmt = c.prepareStatement(SQL_PAGES);
        pstmt.setString(1, parent_id);
        pstmt.setString(2, "PAGE");
        ResultSet rs = pstmt.executeQuery();
        while (rs.next()) {
            String title = rs.getString(1);
            String name = rs.getString(2);
            if (!parent_name.equals("")) {
                title = parent_name + "\\\\" + title;
            }
            Element item = folder.addElement("page");
            item.addElement("title").addText(title);
            item.addElement("name").addText(name);
        }
        rs.close();
        pstmt.close();
    }

    private static final void doFolders(WebContext context, Connection c, Element root, String parent_id, String parent_name) throws SQLException {
        PreparedStatement pstmt = c.prepareStatement(SQL_PAGES);
        pstmt.setString(1, parent_id);
        pstmt.setString(2, "FOLDER");
        ResultSet rs = pstmt.executeQuery();
        while (rs.next()) {
            String title = rs.getString(1);
            String[] role = Util.splitArray((String)rs.getString(3), (String)";");
            if (!context.isUserInAllRoles(role)) continue;
            String id = rs.getString(4);
            if (!parent_name.equals("")) {
                title = parent_name + "\\\\" + title;
            }
            Element group = root.addElement("group");
            group.addAttribute("name", title);
            WebJsEditor.doItems(c, group, id, title);
            WebJsEditor.doFolders(context, c, root, id, title);
        }
        rs.close();
        pstmt.close();
    }

    static {
        imageTypes.add(".png");
        imageTypes.add(".jpg");
        imageTypes.add(".gif");
    }
}

