/*
 * Decompiled with CFR 0.152.
 */
package is.hugvit.bird.client;

import is.hugvit.bird.BirdDatabase;
import is.hugvit.bird.BirdException;
import is.hugvit.bird.BirdPage;
import is.hugvit.bird.BirdSession;
import is.hugvit.bird.Field;
import is.hugvit.bird.Form;
import is.hugvit.bird.WebContext;
import is.hugvit.bird.client.Install;
import is.hugvit.bird.core.BirdUtil;
import is.hugvit.bird.core.WebBirdForm;
import is.hugvit.bird.core.WebMenuEdit;
import is.hugvit.net.QueryString;
import is.hugvit.util.HashMapEx;
import is.hugvit.util.UID;
import is.hugvit.xml.XMLUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.dom4j.Element;

public final class WebFolder
extends WebBirdForm {
    public WebFolder() {
        this.setTable("bird_page");
        this.setRedirect("bird:pages");
        this.add(new Field("title", true));
        this.add(new Field("folder"));
        this.add(new Field("role", 5));
        this.add(new Field("visible", 2));
        this.add(new Field("webrole", 5));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final int getFolderCount(Connection dc, String table, String value) throws SQLException {
        int count = 0;
        PreparedStatement stmt = dc.prepareStatement("select count(*) from " + table + " where folder=?");
        stmt.setString(1, value);
        ResultSet rd = stmt.executeQuery();
        try {
            if (rd.next()) {
                count = rd.getInt(1);
            }
        }
        finally {
            rd.close();
            stmt.close();
        }
        return count;
    }

    private static final boolean canDeleteFolder(String id, Connection dc) throws SQLException {
        int count = WebFolder.getFolderCount(dc, "bird_page", id) + WebFolder.getFolderCount(dc, "bird_file", id);
        return count == 0;
    }

    public void doDelete(WebContext context, Form data) throws BirdException {
        try {
            String id = data.getID();
            if (id.equals("")) {
                context.setRedirectPage("bird:pages");
                return;
            }
            if (WebFolder.canDeleteFolder(id, (Connection)context.getAttribute("bird.connection"))) {
                super.doDelete(context, data);
                context.setRedirectPage("bird:pages", "id=&reload=true");
            } else {
                context.getRootElement().addElement("message").addText(Install.lang.getString("folder_delete_fail"));
            }
        }
        catch (SQLException e) {
            throw new BirdException((Exception)e);
        }
    }

    public final boolean queryOpen(WebContext context, Form data) throws BirdException {
        try {
            Connection dc = (Connection)context.getAttribute("bird.connection");
            super.queryOpen(context, data);
            if (data.isCreate()) {
                QueryString qs = new QueryString(context.getRequest().getQueryString());
                String pid = qs.get("parent");
                PreparedStatement stmt = dc.prepareStatement("select title from bird_page where id=?");
                stmt.setString(1, pid);
                ResultSet rs = stmt.executeQuery();
                if (rs.next()) {
                    data.put("folder", pid);
                    data.put("parent_title", rs.getString(1));
                }
                data.put("visible", "1");
            } else {
                if (data.getID().equals("")) {
                    context.setRedirectPage("bird:pages");
                    return false;
                }
                PreparedStatement stmt = dc.prepareStatement("select title from bird_page where id=?");
                stmt.setString(1, data.getString("folder"));
                ResultSet rs = stmt.executeQuery();
                if (rs.next()) {
                    data.put("parent_title", rs.getString(1));
                }
                rs.close();
                stmt.close();
            }
            return true;
        }
        catch (SQLException e) {
            throw new BirdException((Exception)e);
        }
    }

    protected final void doXML(WebContext context, Form data) throws BirdException {
        super.doXML(context, data);
        Element root = context.getRootElement();
        WebMenuEdit.doRoles((WebContext)context);
        BirdSession session = context.getSession();
        XMLUtil.toXML((Element)root, (String)"web_roles", (Object[])session.getRealm().getRoles());
    }

    public final void doSave(WebContext context, Form data) throws BirdException {
        try {
            BirdPage page;
            data.remove("parent_title");
            BirdDatabase db = context.getSession().getDatabase();
            String id = data.getID();
            if (data.isCreate()) {
                page = db.createPage();
                id = UID.getUID();
                page.put("id", (Object)id);
            } else {
                page = db.getPageByID(data.getID());
            }
            page.put(data.getHashtable());
            page.save();
            Connection c = (Connection)context.getAttribute("bird.connection");
            HashMapEx roles = BirdUtil.getAllWebRolesForFolder((Connection)c, (String)id);
            BirdUtil.updatePageRoles((Connection)c, (String)id, (HashMapEx)roles);
            BirdUtil.updateFileRoles((Connection)c, (String)id, (HashMapEx)roles);
            context.setRedirectPage("bird:pages", "id=" + id + "&reload=true");
        }
        catch (SQLException e) {
            throw new BirdException((Exception)e);
        }
    }
}

