/*
 * Decompiled with CFR 0.152.
 */
package is.hugvit.bird.client;

import is.hugvit.bird.BirdDatabase;
import is.hugvit.bird.BirdException;
import is.hugvit.bird.BirdFile;
import is.hugvit.bird.Field;
import is.hugvit.bird.Form;
import is.hugvit.bird.WebContext;
import is.hugvit.bird.client.Install;
import is.hugvit.bird.client.WebEditPage;
import is.hugvit.bird.core.WebBirdForm;
import is.hugvit.io.ByteArrayInputStreamEx;
import is.hugvit.net.QueryString;
import is.hugvit.util.Util;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Vector;
import org.dom4j.Element;

public final class WebFile
extends WebBirdForm {
    private static final Vector types = new Vector();

    public WebFile() {
        this.setTable("bird_file");
        this.setRedirect("bird:files");
        this.add(new Field("name", true));
        this.add(new Field("description"));
        this.add(new Field("filename", true));
        this.add(new Field("type"));
        this.add(new Field("alt"));
        this.add(new Field("folder"));
        this.add(new Field("encoding"));
    }

    public static final void addFileTypes(WebContext context) {
        Element r = context.getRootElement().addElement("bird_filetypes");
        Enumeration e = types.elements();
        while (e.hasMoreElements()) {
            String value = (String)e.nextElement();
            String name = Install.lang.getString(value.toLowerCase());
            Element f = r.addElement("filetype");
            f.addElement("name").addText(name);
            f.addElement("value").addText(value);
        }
    }

    public void doDelete(WebContext context, Form data) throws BirdException {
        BirdDatabase db = context.getSession().getDatabase();
        BirdFile file = db.getFileByID(data.getID());
        String folder = file.getFolder();
        file.delete();
        context.setRedirectPage("bird:pages", "id=" + folder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void doXML(WebContext context, Form data) throws BirdException {
        try {
            super.doXML(context, data);
            Element root = context.getRootElement();
            Connection dc = (Connection)context.getAttribute("bird.connection");
            Element r = root.addElement("bird_folders");
            WebEditPage.doFolders(context, dc, r, "", "");
            WebFile.addFileTypes(context);
            if (data.getID().equals("")) {
                return;
            }
            PreparedStatement stmt = dc.prepareStatement("select name,filename,width,height,alt from bird_file where id=?");
            stmt.setString(1, data.getID());
            ResultSet rd = stmt.executeQuery();
            try {
                if (rd.next()) {
                    Element f = root.addElement("bird_file");
                    f.addElement("name").addText(rd.getString(1));
                    String s = rd.getString(2);
                    if (s == null) {
                        s = "";
                    }
                    f.addElement("filename").addText(s);
                    f.addElement("width").addText(rd.getInt(3) + "");
                    f.addElement("height").addText(rd.getInt(4) + "");
                    s = rd.getString(5);
                    if (s == null) {
                        s = "";
                    }
                    f.addElement("alt").addText(s);
                }
            }
            finally {
                rd.close();
                stmt.close();
            }
        }
        catch (SQLException e) {
            throw new BirdException((Exception)e);
        }
    }

    public final boolean queryOpen(WebContext context, Form data) throws BirdException {
        try {
            super.queryOpen(context, data);
            if (data.isCreate()) {
                data.put("type", "IMAGE");
                QueryString qs = new QueryString(context.getRequest().getQueryString());
                data.put("folder", qs.get("parent"));
            }
            data.put("body", "");
            String type = data.getString("type");
            if (type.equals("CODE")) {
                Connection dc = (Connection)context.getAttribute("bird.connection");
                PreparedStatement stmt = dc.prepareStatement("select encoding,size,body from bird_file where id=?");
                stmt.setString(1, data.getID());
                ResultSet rs = stmt.executeQuery();
                if (rs.next()) {
                    String encoding = rs.getString(1);
                    if (encoding == null) {
                        encoding = "ISO-8859-1";
                    }
                    int size = rs.getInt(2);
                    InputStream in = rs.getBinaryStream(3);
                    InputStreamReader r = new InputStreamReader(in, encoding);
                    StringWriter w = new StringWriter(size);
                    Util.writeReader((Reader)r, (Writer)w);
                    ((Reader)r).close();
                    data.put("body", ((Object)w).toString());
                }
                rs.close();
                stmt.close();
            }
            return true;
        }
        catch (IOException e) {
            throw new BirdException((Exception)e);
        }
        catch (SQLException e) {
            throw new BirdException((Exception)e);
        }
    }

    public final boolean querySave(WebContext context, Form data) throws BirdException {
        if (data.getString("type").equals("CODE") && data.getString("filename").equals("")) {
            data.setError("filename");
            return false;
        }
        return super.querySave(context, data);
    }

    public final void doSave(WebContext context, Form data) throws BirdException {
        try {
            String type = data.getString("type");
            if (type.equals("CODE")) {
                String encoding = data.getString("encoding");
                ByteArrayInputStreamEx in = new ByteArrayInputStreamEx(data.getString("body").getBytes(encoding));
                data.put("body", (Object)in);
            } else {
                InputStream in = data.getInputStream("file");
                if (in != null) {
                    String filename = data.getString("filename");
                    if (filename.equals("")) {
                        filename = data.getFilename("file");
                    }
                    data.put("filename", filename);
                    data.put("body", (Object)in);
                } else {
                    data.remove("body");
                }
            }
            BirdDatabase db = context.getSession().getDatabase();
            BirdFile h = data.isCreate() ? db.createFile() : db.getFileByID(data.getID());
            h.put(data.getHashtable());
            h.save();
            String folder = data.getString("folder");
            String redirect = "bird_pages.html?id=" + folder;
            context.setRedirectURL(redirect);
        }
        catch (IOException e) {
            throw new BirdException((Exception)e);
        }
    }

    static {
        types.addElement("CODE");
        types.addElement("IMAGE");
        types.addElement("ATTACHMENT");
    }
}

