/*
 * Decompiled with CFR 0.152.
 */
package is.hugvit.bird.client;

import is.hugvit.bird.BirdDatabase;
import is.hugvit.bird.BirdException;
import is.hugvit.bird.BirdPage;
import is.hugvit.bird.BirdPageType;
import is.hugvit.bird.Field;
import is.hugvit.bird.Form;
import is.hugvit.bird.WebContext;
import is.hugvit.bird.client.Install;
import is.hugvit.bird.client.WebPageType;
import is.hugvit.bird.core.BirdUtil;
import is.hugvit.bird.core.WebBirdForm;
import is.hugvit.net.QueryString;
import is.hugvit.util.Util;
import is.hugvit.xml.HtmlConverter;
import is.hugvit.xml.ParseException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;
import org.dom4j.Element;

public final class WebEditPage
extends WebBirdForm {
    private static final Vector status = new Vector();
    private DateFormat df = DateFormat.getDateInstance(3);

    public WebEditPage() {
        this.setTable("bird_page");
        this.setRedirect("bird:pages");
        this.add(new Field("name"));
        this.add(new Field("title", true));
        this.add(new Field("alias"));
        this.add(new Field("pagetype"));
        this.add(new Field("elements", 5));
        this.add(new Field("showlist"));
        this.add(new Field("lists", 5));
        this.add(new Field("templates", 5));
        this.add(new Field("folder"));
        this.add(new Field("pagedate", 4));
        this.add(new Field("listcount", 1));
        this.add(new Field("body"));
        this.add(new Field("status"));
        this.add(new Field("description"));
        this.add(new Field("startdate", 4));
        this.add(new Field("enddate", 4));
        this.add(new Field("visible", 2));
        this.add(new Field("role"));
        this.add(new Field("alttitle"));
        this.add(new Field("listimage"));
        this.add(new Field("lang"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final void doFolders(WebContext context, Connection dc, Element r, String parent, String pid) throws BirdException {
        try {
            PreparedStatement stmt = dc.prepareStatement("select role,id,title from bird_page where type='FOLDER' and folder=? order by title");
            stmt.setString(1, pid);
            ResultSet rd = stmt.executeQuery();
            try {
                while (rd.next()) {
                    String[] role = Util.splitArray((String)rd.getString(1), (String)";");
                    if (!context.isUserInAllRoles(role)) continue;
                    String id = rd.getString(2);
                    String title = rd.getString(3);
                    if (!parent.equals("")) {
                        title = parent + "\\" + title;
                    }
                    Element item = r.addElement("folder");
                    item.addElement("id").addText(id);
                    item.addElement("name").addText(title);
                    WebEditPage.doFolders(context, dc, r, title, id);
                }
            }
            finally {
                rd.close();
                stmt.close();
            }
        }
        catch (SQLException e) {
            throw new BirdException((Exception)e);
        }
    }

    public void doDelete(WebContext context, Form data) throws BirdException {
        if (!BirdUtil.checkPageRole((WebContext)context, (String)data.getID())) {
            return;
        }
        BirdPage page = context.getSession().getDatabase().getPageByID(data.getID());
        String folder = page.getFolder();
        page.delete();
        context.setRedirectPage(this.redirect, "id=" + folder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void doXML(WebContext context, Form data) throws BirdException {
        try {
            super.doXML(context, data);
            Element root = context.getRootElement();
            String dateformat = Util.getShortDatePattern();
            root.addElement("bird_dateformat").addText(dateformat);
            Connection dc = (Connection)context.getAttribute("bird.connection");
            Element r = context.getRootElement().addElement("bird_folders");
            WebEditPage.doFolders(context, dc, r, "", "");
            WebPageType.addElementsXML(context);
            WebPageType.addTemplatesXML(context);
            Element l = root.addElement("bird_language");
            Vector<Locale> languageList = this.getLanguageList();
            for (Locale loc : languageList) {
                Element li = l.addElement("item");
                li.addElement("name").setText(loc.getDisplayLanguage());
                li.addElement("value").setText(loc.getLanguage());
            }
            Element s = root.addElement("bird_status");
            Enumeration n = status.elements();
            while (n.hasMoreElements()) {
                String name = (String)n.nextElement();
                Element i = s.addElement("item");
                i.addElement("name").addText(Install.lang.getString("status." + name.toLowerCase()));
                i.addElement("value").addText(name);
            }
            Element e = root.addElement("bird_pagetypes");
            PreparedStatement stmt = dc.prepareStatement("select name,role from bird_pagetype where (isprivate is null or isprivate='0') order by name");
            ResultSet rd = stmt.executeQuery();
            try {
                while (rd.next()) {
                    String name = rd.getString(1);
                    String role = rd.getString(2);
                    if (role != null && !role.equals("") && !context.isUserInRole(role)) continue;
                    e.addElement("name").addText(name);
                }
            }
            finally {
                rd.close();
                stmt.close();
            }
            e = root.addElement("bird_lists");
            stmt = dc.prepareStatement("select name from bird_list order by name");
            rd = stmt.executeQuery();
            try {
                while (rd.next()) {
                    e.addElement("name").addText(rd.getString(1));
                }
            }
            finally {
                rd.close();
                stmt.close();
            }
        }
        catch (SQLException e) {
            throw new BirdException((Exception)e);
        }
    }

    private static final void setBodyError(ParseException e, Form data) {
        data.setError("body");
        String msg = e.getMessage();
        if (e.getLine() != null) {
            msg = msg + "\r\n" + e.getLine();
        }
        data.setMessage(msg);
    }

    public final boolean queryOpen(WebContext context, Form data) throws BirdException {
        try {
            super.queryOpen(context, data);
            if (!BirdUtil.checkPageRole((WebContext)context, (String)data.getID())) {
                return false;
            }
            String body = data.getString("body");
            try {
                HtmlConverter h = new HtmlConverter();
                h.setWriteAlternateXSL(true);
                StringReader in = new StringReader(body);
                StringWriter out = new StringWriter(body.length());
                h.parse((Reader)in, (Writer)out);
                data.put("body", out.toString());
            }
            catch (ParseException e) {
                WebEditPage.setBodyError(e, data);
            }
            if (data.isCreate()) {
                BirdDatabase db;
                BirdPageType pagetype;
                data.put("pagedate", (Object)new Date());
                data.put("status", "APPROVED");
                data.put("visible", "1");
                data.put("lang", context.getSession().getLocale().getLanguage());
                QueryString qs = new QueryString(context.getRequest().getQueryString());
                data.put("folder", qs.get("folder"));
                String ptype = qs.get("pagetype");
                if (!ptype.equals("") && (pagetype = (db = context.getSession().getDatabase()).getPageTypeByID(ptype)) != null) {
                    data.put("pagetype", pagetype.getName());
                    BirdPage page = db.createPage(pagetype.getName());
                    data.put("lists", page.get("lists"));
                    data.put("enddate", page.get("enddate"));
                    String folder = (String)page.get("folder");
                    if (!folder.equals("")) {
                        data.put("folder", folder);
                    }
                }
            }
            return true;
        }
        catch (BirdException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BirdException(e);
        }
    }

    public final boolean querySave(WebContext context, Form data) throws BirdException {
        try {
            BirdDatabase db;
            BirdPage page;
            boolean ok = super.querySave(context, data);
            if (!ok) {
                return false;
            }
            if (!BirdUtil.checkPageRole((WebContext)context, (String)data.getID())) {
                return false;
            }
            String name = data.getString("name");
            name = this.getLocalizedPageKey(name, data.getString("lang"), context.getSession().getLocale().getLanguage());
            data.put("name", name);
            if (!(name.equals("") || (page = (db = context.getSession().getDatabase()).getPageByName(name)) == null || !data.isCreate() && data.getID().equals(page.getID()))) {
                data.setError("name");
                return false;
            }
            String body = data.getString("body");
            HtmlConverter h = new HtmlConverter();
            h.setReadAlternateXSL(true);
            h.setDropEmptyParas(true);
            h.setMicrosoftWord(true);
            StringReader in = new StringReader(body);
            StringWriter out = new StringWriter(body.length());
            h.parse((Reader)in, (Writer)out);
            body = out.toString();
            data.put("body", body);
            data.remove("body_debug");
            data.remove("folder_id");
            return true;
        }
        catch (ParseException e) {
            WebEditPage.setBodyError(e, data);
            System.out.println("querySave: " + e.getMessage());
            return false;
        }
        catch (IOException e) {
            throw new BirdException((Exception)e);
        }
    }

    public final void doSave(WebContext context, Form data) throws BirdException {
        String redirect = data.getString("redirect");
        data.remove("redirect");
        BirdDatabase db = context.getSession().getDatabase();
        BirdPage page = data.isCreate() ? db.createPage() : db.getPageByID(data.getID());
        page.put(data.getHashtable());
        page.save();
        if (redirect.equals("")) {
            String folder = data.getString("folder");
            redirect = "bird_pages.html?id=" + folder;
        }
        context.setRedirectURL(redirect);
    }

    private Vector<Locale> getLanguageList() {
        Vector<Locale> v = new Vector<Locale>();
        Locale[] list = DateFormat.getAvailableLocales();
        ArrayList<Locale> localeList = new ArrayList<Locale>();
        ArrayList<String> codeList = new ArrayList<String>();
        for (Locale locale : list) {
            if (codeList.contains(locale.getLanguage())) continue;
            localeList.add(locale);
            codeList.add(locale.getLanguage());
        }
        for (Locale locale : localeList) {
            v.add(locale);
        }
        return v;
    }

    private String getLocalizedPageKey(String pagekey, String locale, String defaultLocale) {
        if (pagekey != null && !"".equals(pagekey)) {
            String[] tokens = pagekey.split("\\.");
            if (locale != null && !"".equals(locale)) {
                String match;
                if (tokens.length > 1 && pagekey.endsWith(match = "." + locale + "." + tokens[tokens.length - 1])) {
                    return pagekey;
                }
                if (locale.equals(defaultLocale)) {
                    if (tokens.length > 2) {
                        String checkToken = tokens[tokens.length - 2];
                        if (locale.equals(checkToken)) {
                            return pagekey.replace("." + locale + ".", ".");
                        }
                        if (checkToken.length() == 2) {
                            String newKey = new String();
                            for (int i = 0; i < tokens.length; ++i) {
                                if (i == tokens.length - 2) continue;
                                newKey = newKey + tokens[i];
                                if (i >= tokens.length - 1) continue;
                                newKey = newKey + ".";
                            }
                            return newKey;
                        }
                    }
                    return pagekey;
                }
                if (pagekey.contains(".htm")) {
                    return pagekey.replace(".htm", "." + locale + ".htm");
                }
                if (pagekey.contains(".html")) {
                    return pagekey.replace(".html", "." + locale + ".html");
                }
            } else {
                return pagekey;
            }
        }
        return pagekey;
    }

    static {
        status.addElement("APPROVED");
        status.addElement("EDIT");
        status.addElement("EXPIRED");
    }
}

