/*
 * Decompiled with CFR 0.152.
 */
package is.hugvit.bird.client;

import is.hugvit.bird.BirdException;
import is.hugvit.bird.WebContext;
import is.hugvit.bird.WebElementBase;
import is.hugvit.util.Util;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.dom4j.Element;

public final class WebAllPages
extends WebElementBase {
    private static final String SQL_PAGES = "select title,name,role,id from bird_page where folder=? and type=? and (isprivate is null or isprivate='0') order by sort";

    private static final void doItems(Connection c, Element folder, String parent_id, String parent_name) throws SQLException {
        PreparedStatement pstmt = c.prepareStatement(SQL_PAGES);
        pstmt.setString(1, parent_id);
        pstmt.setString(2, "PAGE");
        ResultSet rs = pstmt.executeQuery();
        while (rs.next()) {
            String title = rs.getString(1);
            String name = rs.getString(2);
            if (!parent_name.equals("")) {
                title = parent_name + "\\" + title;
            }
            Element item = folder.addElement("page");
            item.addElement("title").addText(title);
            item.addElement("name").addText(name);
        }
        rs.close();
        pstmt.close();
    }

    private static final void doFolders(WebContext context, Connection c, Element root, String parent_id, String parent_name) throws SQLException {
        PreparedStatement pstmt = c.prepareStatement(SQL_PAGES);
        pstmt.setString(1, parent_id);
        pstmt.setString(2, "FOLDER");
        ResultSet rs = pstmt.executeQuery();
        while (rs.next()) {
            String title = rs.getString(1);
            String[] role = Util.splitArray((String)rs.getString(3), (String)";");
            if (!context.isUserInAllRoles(role)) continue;
            String id = rs.getString(4);
            if (!parent_name.equals("")) {
                title = parent_name + "\\" + title;
            }
            Element group = root.addElement("group");
            group.addAttribute("name", title);
            WebAllPages.doItems(c, group, id, title);
            WebAllPages.doFolders(context, c, root, id, title);
        }
        rs.close();
        pstmt.close();
    }

    public final void doGet(WebContext context) throws BirdException {
        Connection c = (Connection)context.getAttribute("bird.connection");
        Element root = context.getRootElement().addElement("bird_pages");
        try {
            WebAllPages.doItems(c, root, "", "");
            WebAllPages.doFolders(context, c, root, "", "");
        }
        catch (SQLException e) {
            throw new BirdException((Exception)e);
        }
    }
}

