/*
 * Decompiled with CFR 0.152.
 */
package is.hugvit.bird.jaas.security;

import is.hugvit.bird.jaas.IBirdUserPrincipal;
import is.hugvit.bird.jaas.security.client.BirdAuthentication;
import is.hugvit.bird.jaas.security.client.BirdAuthenticationService;
import is.hugvit.bird.jaas.security.client.BirdUserPrincipal;
import java.net.URL;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import javax.xml.ws.BindingProvider;
import org.apache.log4j.Logger;

public abstract class AbstractLoginModule
implements LoginModule {
    private static final Logger logger = Logger.getLogger(AbstractLoginModule.class);
    protected String jaasConfigFile;
    protected String jaasPolicyFile;
    protected CallbackHandler callbackHandler;
    protected Subject subject;
    protected Map sharedState;
    protected Map options;
    protected IBirdUserPrincipal currentUser = null;
    protected String birdLoginServiceUrl;
    protected boolean debug = false;

    @Override
    public boolean abort() throws LoginException {
        return false;
    }

    @Override
    public boolean commit() throws LoginException {
        throw new LoginException("Nothing to commit");
    }

    public void initialize(Subject sub, CallbackHandler handler, Map state, Map opts) {
        this.subject = sub;
        this.callbackHandler = handler;
        this.sharedState = state;
        this.options = opts;
        this.setBaseOptions();
    }

    @Override
    public boolean login() throws LoginException {
        this.debug(this.getClass().getName() + " login");
        throw new LoginException("Nothing to login");
    }

    @Override
    public boolean logout() throws LoginException {
        this.debug(this.getClass().getName() + " logout");
        try {
            Set<IBirdUserPrincipal> principals = this.subject.getPrincipals(IBirdUserPrincipal.class);
            this.subject.getPrincipals().removeAll(principals);
            principals = null;
            return true;
        }
        catch (Exception ex) {
            throw new LoginException(ex.getMessage());
        }
    }

    public String getJaasConfigFile() {
        return this.jaasConfigFile;
    }

    public void setJaasConfigFile(String jaasConfigFile) {
        this.jaasConfigFile = jaasConfigFile;
    }

    public String getJaasPolicyFile() {
        return this.jaasPolicyFile;
    }

    public void setJaasPolicyFile(String jaasPolicyFile) {
        this.jaasPolicyFile = jaasPolicyFile;
    }

    private final void setBaseOptions() {
        this.debug(this.getClass().getName() + " setBaseOptions");
        if (this.options != null) {
            Object oServiceUrl = this.options.get("birdLoginService");
            Object oDebug = this.options.get("debug");
            if (oServiceUrl != null) {
                this.birdLoginServiceUrl = (String)oServiceUrl;
            }
            if (oDebug != null) {
                this.debug = "true".equals((String)oDebug);
            }
        }
    }

    protected void debug(String message) {
        if (this.debug) {
            logger.info((Object)("### " + message));
        }
    }

    protected BirdUserPrincipal birdAuthenticate(String username, String password) throws LoginException {
        URL url = AbstractLoginModule.class.getResource("/META-INF/wsdl/Authentication.wsdl");
        BirdAuthenticationService client = new BirdAuthenticationService(url);
        BirdAuthentication proxy = client.getBirdAuthenticationPort();
        this.debug("Launching endpoint authentication");
        ((BindingProvider)proxy).getRequestContext().put("javax.xml.ws.service.endpoint.address", this.birdLoginServiceUrl);
        this.debug("WS Login Provider set to: " + this.birdLoginServiceUrl);
        BirdUserPrincipal bp = proxy.authenticate(username, password);
        if (bp == null) {
            logger.info((Object)("Authentication failed. User: " + username));
            throw new LoginException("Authentication failed. User: " + username);
        }
        if (bp.getRoles() == null || bp.getRoles().size() == 0) {
            throw new LoginException("Authentication failed: No roles are assigned to user");
        }
        return bp;
    }
}

