/*
 * Decompiled with CFR 0.152.
 */
package is.hugvit.bird.jaas.handlers;

import is.hugvit.bird.jaas.callback.CertificateSubjectCallback;
import java.io.IOException;
import java.util.StringTokenizer;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;

public class CertificateSubjectCallbackHandler
implements CallbackHandler {
    private String certificateSubject;

    public CertificateSubjectCallbackHandler(String certificateSubject) {
        this.certificateSubject = certificateSubject;
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        if (!(callbacks[0] instanceof CertificateSubjectCallback)) {
            throw new UnsupportedCallbackException(callbacks[0], "Unrecognized Callback");
        }
        CertificateSubjectCallback cc = (CertificateSubjectCallback)callbacks[0];
        this.handleCallback(cc);
    }

    private void handleCallback(CertificateSubjectCallback callback) throws IOException {
        if (this.certificateSubject != null) {
            StringTokenizer st = new StringTokenizer(this.certificateSubject, ",");
            while (st.hasMoreElements()) {
                String token = st.nextToken().trim();
                String[] keypair = token.split("=");
                if (keypair.length != 2) continue;
                String key = keypair[0];
                String val = keypair[1];
                if ("CN".equals(key)) {
                    callback.setCommonName(val);
                    continue;
                }
                if ("SERIALNUMBER".equals(key)) {
                    callback.setUserName(val);
                    continue;
                }
                if ("OU".equals(key)) {
                    callback.getOrganizationUnit().add(val);
                    continue;
                }
                if (!"C".equals(key)) continue;
                callback.setCountry(val);
            }
        } else {
            throw new IOException("No certificate Subject has been set!");
        }
    }
}

