/*
 * Decompiled with CFR 0.152.
 */
package is.hugvit.bird.jaas.callback;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;

public class CertificateSubjectCallback
extends NameCallback
implements Callback {
    private static final long serialVersionUID = 1L;
    private boolean isValid = false;
    private String commonName;
    private String country;
    private String userName;
    private List<String> organizationUnit = new ArrayList<String>();

    public CertificateSubjectCallback(String prompt) {
        super(prompt);
    }

    public CertificateSubjectCallback(String prompt, String defaultName) {
        super(prompt, defaultName);
    }

    public String getCommonName() {
        return this.commonName;
    }

    public void setCommonName(String commonName) {
        this.commonName = commonName;
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public List<String> getOrganizationUnit() {
        return this.organizationUnit;
    }

    public void setOrganizationUnit(List<String> organizationUnit) {
        this.organizationUnit = organizationUnit;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public final void populateValues() {
        StringTokenizer st;
        String certString = this.getName();
        if (certString != null && (st = new StringTokenizer(certString, ",")).countTokens() > 0) {
            while (st.hasMoreElements()) {
                String token = st.nextToken().trim();
                String[] keypair = token.split("=");
                if (keypair.length != 2) continue;
                String key = keypair[0].trim();
                String val = keypair[1].trim();
                if ("CN".equals(key)) {
                    this.setCommonName(val);
                    continue;
                }
                if ("SERIALNUMBER".equals(key)) {
                    this.setUserName(val);
                    continue;
                }
                if ("OU".equals(key)) {
                    this.getOrganizationUnit().add(val);
                    continue;
                }
                if (!"C".equals(key)) continue;
                this.setCountry(val);
            }
            if (this.commonName != null) {
                this.isValid = true;
            }
            if (this.userName == null && this.commonName != null) {
                this.userName = this.commonName;
            }
        }
    }

    public String toString() {
        String s = "";
        s = s + "Common Name: " + this.commonName + "\n";
        s = s + "Username: " + this.userName + "\n";
        s = s + "Country: " + this.country + "\n";
        String org = "";
        for (String o : this.organizationUnit) {
            org = org + o + " ";
        }
        s = s + "Organization Unit: " + org.trim() + "\n";
        return s;
    }
}

