package is.hugvit.bird.jaas.security;

import is.hugvit.bird.jaas.IBirdRolePrincipal;
import is.hugvit.bird.jaas.security.client.BirdAuthentication;
import is.hugvit.bird.jaas.security.client.BirdAuthenticationService;

import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;

import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import javax.xml.ws.BindingProvider;

public class PlainLoginModule extends AbstractLoginModule implements LoginModule {
	
		
	public PlainLoginModule() {
		super();
		debug(getClass().getName() + " loaded");
	}
	
	
	public boolean commit() throws LoginException {
		debug(getClass().getName() + " Commit");
    	
    	if (currentUser == null) {
    		throw new LoginException("No user to commit");
    	}
    	
        try {
        		
    		subject.getPrincipals().add(currentUser);
    		Iterator<String> it = currentUser.getRoles().iterator();
    		
    		while (it.hasNext()) {
    			IBirdRolePrincipal birdRole = new BirdRolePrincipal(it.next());
    			if (!subject.getPrincipals().contains(birdRole)) {
    				subject.getPrincipals().add(birdRole);
    				debug("Adding role: " + birdRole.getName());
    			}
    		}
    		
    		debug(getClass().getName() + " Commit finished");
    		
    		return true;

        } catch (Exception ex) {
            throw new LoginException(ex.getMessage());
        }
	}


	public boolean abort() throws LoginException {
		return super.abort();
	}

	public void initialize(Subject sub, CallbackHandler handler, Map state, Map opts) {
		super.initialize(sub, handler, state, opts);
	}

	public boolean login() throws LoginException {
		debug(getClass().getName() + " login");
		Callback[] callbacks = new Callback[2];
        callbacks[0] = new NameCallback("login");
        callbacks[1] = new PasswordCallback("password", true);

        if (this.birdLoginServiceUrl == null || "".equals(birdLoginServiceUrl)) {
        	throw new LoginException("Cannot proceed, Bird login Service is not defined.");
        }
        
        try {

        	callbackHandler.handle(callbacks);

            String name = ((NameCallback) callbacks[0]).getName();
            String password = String.valueOf(((PasswordCallback) callbacks[1]).getPassword());

            debug("user: " + name + " pass: " + password);
            
            
            // Create the proxy for the Bird Authentication Service
            URL url = PlainLoginModule.class.getResource("/META-INF/wsdl/Authentication.wsdl");
            BirdAuthenticationService client = new BirdAuthenticationService(url);
            BirdAuthentication proxy = client.getBirdAuthenticationPort();
            
            debug("Launching endpoint authentication");
            
            // Set the correct endpoint as it was passed from the JAAS config
            ((BindingProvider)proxy).getRequestContext().put
				(BindingProvider.ENDPOINT_ADDRESS_PROPERTY, this.birdLoginServiceUrl);
            
            debug("WS Login Provider set to: " + this.birdLoginServiceUrl);
            
            is.hugvit.bird.jaas.security.client.BirdUserPrincipal 
            	birdPrincipal = proxy.authenticate(name, password);
            
            if (birdPrincipal == null) {
            	//throw new LoginException("Authentication failed");
            	debug("Authentication failed. User: " + name);
            	return false;
            }
            
            if (birdPrincipal.getRoles() == null || birdPrincipal.getRoles().size()==0) {
            	throw new LoginException("Authentication failed: No roles are assigned to user");
            }
              
            currentUser = new BirdUserPrincipal();
            currentUser.setName(birdPrincipal.getName());
            currentUser.setRoles(birdPrincipal.getRoles());
            currentUser.setUserId(birdPrincipal.getUserId());
            currentUser.setFullName(birdPrincipal.getFullName());
            currentUser.setEmail(birdPrincipal.getEmail());
            
            
            debug("User has been successfully set - Login Succeded");
            
            return true;

        } catch (IOException ex) {
            throw new LoginException(ex.getMessage());
        } catch (UnsupportedCallbackException ex) {
           throw new LoginException(ex.getMessage());
        }
	}

	public boolean logout() throws LoginException {
		debug("Logout");
    	return super.logout();
	}
	
	
    
	
}
