package is.hugvit.bird.jaas.security;

import is.hugvit.bird.jaas.IBirdRolePrincipal;
import is.hugvit.bird.jaas.callback.CertificateSubjectCallback;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;

import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public class CertificateSubjectLoginModule extends AbstractLoginModule implements LoginModule {
	
	public CertificateSubjectLoginModule() {
	
	}
	
	public void initialize(Subject sub, CallbackHandler handler, Map sharedState, Map opts) {
		super.initialize(sub, handler, sharedState, opts);
	}
	
	public boolean commit() throws LoginException {
		debug("Commit");
    	
    	if (currentUser == null) {
    		throw new LoginException("No user to commit");
    	}
    	
        try {
        		
    		subject.getPrincipals().add(currentUser);
    		subject.getPrincipals().add(new BirdRolePrincipal("citizen"));
    		subject.getPrincipals().add(new BirdRolePrincipal("administrator"));
    		Iterator<String> it = currentUser.getRoles().iterator();
    		
    		while (it.hasNext()) {
    			IBirdRolePrincipal birdRole = new BirdRolePrincipal(it.next());
    			if (!subject.getPrincipals().contains(birdRole)) {
    				subject.getPrincipals().add(birdRole);
    				debug("Adding role: " + birdRole.getName());
    			}
    		}
    		
    		debug("Commit finished for user: " + currentUser.getName());
    		
    		return true;
        	            

        } catch (Exception ex) {
            throw new LoginException(ex.getMessage());
        }
	}


	public boolean login() throws LoginException {

		CertificateSubjectCallback cc = new CertificateSubjectCallback("Name");
		Callback[] callbacks = {cc};
  	    

		debug("Certificate login");
		
		try {
			if (callbackHandler == null) { 
				throw new LoginException("No Callback Handler available!");
			}

			callbackHandler.handle(callbacks);
			cc.populateValues();
			
			if (!cc.isValid()) {
				throw new LoginException("Data in not from a Certificate or the Certificate is not valid!");
			}

			if (cc.getUserName() == null || "".equals(cc.getUserName())) {
				throw new LoginException("Could not retrieve sufficient data from certificate");
			}
			
			debug("Got valid data from Certificate collection");
			debug("Certificate CN: " + cc.getCommonName());
			debug("Certifiacte Name: " + cc.getName());
			debug("Certificate Username: " + cc.getUserName());
			debug("Certificate Country: " + cc.getCountry());
			
			
			currentUser = new BirdUserPrincipal();
            currentUser.setName(cc.getUserName());
            currentUser.setRoles(Arrays.asList(new String[] {"citizen"}));
            currentUser.setCertificateAuthentication(true);
		    
            debug("User has been set");
            
		    return true;
			
		} catch (IOException ex) {
			throw new LoginException(ex.getMessage());
		} catch (UnsupportedCallbackException ex) {
			throw new LoginException(ex.getMessage());
		}
	}

	public boolean logout() throws LoginException {
		return super.logout();
	}
	

	public boolean abort() throws LoginException {
		return super.abort();
	}

	

}
