/**
 * 
 */
package is.hugvit.bird.jaas.security;

import is.hugvit.bird.jaas.IBirdUserPrincipal;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * @author konni
 *
 */
public class BirdUserPrincipal implements IBirdUserPrincipal, Serializable {

	private String userId;
	private String username;
	private String fullname;
	private String email;
	private String ip;
	private String locale;
	private boolean isCertificateAuthentication = false;
	private boolean isDirectoryAuthentication = false;
	private List roles = new ArrayList();
	
	
	/**
	 * 
	 */
	private static final long serialVersionUID = -3280934707383345048L;

	
	public BirdUserPrincipal() {
		
	}
	
	public BirdUserPrincipal(String username) {
		this.username = username;
	}
	
	public BirdUserPrincipal(String userId, String username, String fullname, String email) {
		this.userId = userId;
		this.userId = username;
		this.fullname = fullname;
		this.email = email;
	}
	
	public BirdUserPrincipal(String userId, String username, 
			String fullname, String email, List roles) {
		this.userId = userId;
		this.userId = username;
		this.fullname = fullname;
		this.email = email;
		this.roles = roles;
	}
	
	/* (non-Javadoc)
	 * @see is.hugvit.bird.jaas.IBirdUserPrincipal#getEmail()
	 */
	public String getEmail() {
		return this.email;
	}

	/* (non-Javadoc)
	 * @see is.hugvit.bird.jaas.IBirdUserPrincipal#getFullName()
	 */
	public String getFullName() {
		return this.fullname;
	}

	/* (non-Javadoc)
	 * @see is.hugvit.bird.jaas.IBirdUserPrincipal#getRoles()
	 */
	public List getRoles() {
		return this.roles;
	}

	/* (non-Javadoc)
	 * @see is.hugvit.bird.jaas.IBirdUserPrincipal#getUserId()
	 */
	public String getUserId() {
		return this.userId;
	}

	/* (non-Javadoc)
	 * @see is.hugvit.bird.jaas.IBirdUserPrincipal#setEmail(java.lang.String)
	 */
	public void setEmail(String email) {
		this.email = email;
	}

	/**
	 * @return the ip
	 */
	public String getIp() {
		return ip;
	}

	/**
	 * @param ip the ip to set
	 */
	public void setIp(String ip) {
		this.ip = ip;
	}

	/* (non-Javadoc)
	 * @see is.hugvit.bird.jaas.IBirdUserPrincipal#setFullName(java.lang.String)
	 */
	public void setFullName(String name) {
		this.fullname = name;
	}

	/* (non-Javadoc)
	 * @see is.hugvit.bird.jaas.IBirdUserPrincipal#setRoles(java.util.List)
	 */
	public void setRoles(List roles) {
		if (roles != null) {
			this.roles = roles;
		}
	}

	/* (non-Javadoc)
	 * @see is.hugvit.bird.jaas.IBirdUserPrincipal#setUserId(java.lang.String)
	 */
	public void setUserId(String id) {
		this.userId = id;
	}

	/* (non-Javadoc)
	 * @see java.security.Principal#getName()
	 */
	public String getName() {
		return this.username;
	}

	public void setName(String name) {
		this.username = name;
	}

	/**
	 * @return the isCertificateAuthentication
	 */
	public boolean isCertificateAuthentication() {
		return isCertificateAuthentication;
	}

	/**
	 * @param isCertificateAuthentication the isCertificateAuthentication to set
	 */
	public void setCertificateAuthentication(boolean isCertificateAuthentication) {
		this.isCertificateAuthentication = isCertificateAuthentication;
	}

	
	public boolean isDirectoryAuthentication() {
		return isDirectoryAuthentication;
	}

	
	public void setDirectoryAuthentication(boolean isDirectoryAuthentication) {
		this.isDirectoryAuthentication = isDirectoryAuthentication;
		
	}

	public String getUserIp() {
		return this.ip;
	}

	public void setUserIp(String userIp) {
		this.ip = userIp;
	}

	
	public void setLocale(String locale) {
		this.locale = locale;		
	}

	
	public String getLocale() {
		return locale;
	}
	
	

}
