package is.hugvit.bird.jaas.security;

import is.hugvit.bird.jaas.IBirdUserPrincipal;
import is.hugvit.bird.jaas.security.client.BirdAuthentication;
import is.hugvit.bird.jaas.security.client.BirdAuthenticationService;

import java.net.URL;
import java.util.Map;
import java.util.Set;

import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import javax.xml.ws.BindingProvider;

import org.apache.log4j.Logger;

public abstract class AbstractLoginModule implements LoginModule {

	private static final Logger logger = Logger.getLogger(AbstractLoginModule.class);
	
	protected String jaasConfigFile;
	protected String jaasPolicyFile;
		
    /** Callback handler to store between initialization and authentication. */
	protected CallbackHandler callbackHandler;

    /** Subject to store. */
	protected Subject subject;
    
	/** The shared state to store between initialization and authentication **/
	protected Map sharedState;
	
	/** The options to store between initialization and authentication **/
	protected Map options;
	
    /** The principal returned from the BIRD service **/
	protected IBirdUserPrincipal currentUser = null;

	protected String birdLoginServiceUrl;
    
	protected boolean debug = false;
	
	public AbstractLoginModule() {
	
	}
	
	
	public boolean abort() throws LoginException {
		return false;
	}

	public boolean commit() throws LoginException {
		throw new LoginException("Nothing to commit");
	}

	public void initialize(Subject sub, CallbackHandler handler, Map state, Map opts) {
		this.subject = sub;
		this.callbackHandler = handler;
		this.sharedState = state;
		this.options = opts;
		
		this.setBaseOptions();
	}

	public boolean login() throws LoginException {
		debug(getClass().getName() + " login");
		throw new LoginException("Nothing to login");
	}

	public boolean logout() throws LoginException {
		debug(getClass().getName() + " logout");
		try {

        	Set<IBirdUserPrincipal> principals = subject.getPrincipals(IBirdUserPrincipal.class);
            subject.getPrincipals().removeAll(principals);
            principals = null;
        	
            return true;

        } catch (Exception ex) {
            throw new LoginException(ex.getMessage());
        }
	}
	
	public String getJaasConfigFile() {
        return jaasConfigFile;
    }

    public void setJaasConfigFile(String jaasConfigFile) {
        this.jaasConfigFile = jaasConfigFile;
    }

    /**
	 * @return the jaasPolicyFile
	 */
	public String getJaasPolicyFile() {
		return jaasPolicyFile;
	}


	/**
	 * @param jaasPolicyFile the jaasPolicyFile to set
	 */
	public void setJaasPolicyFile(String jaasPolicyFile) {
		this.jaasPolicyFile = jaasPolicyFile;
	}
	
	private final void setBaseOptions() {
		debug(getClass().getName() + " setBaseOptions");
		if (options != null) {
			Object oServiceUrl = options.get("birdLoginService");
	        Object oDebug = options.get("debug");
	        
	        if (oServiceUrl != null) {
	        	this.birdLoginServiceUrl = (String) oServiceUrl;
	        }
	        if (oDebug != null) {
	        	this.debug = "true".equals((String)oDebug);
	        }
		}
	}
	
	/**
     * Log the message if debug in jaas.conf is enabled
     * 
     * @param message
     */
    protected void debug(String message) {
    	if (this.debug == true) {
    		logger.info("### " + message);
    	}
    }
    
    protected is.hugvit.bird.jaas.security.client.BirdUserPrincipal birdAuthenticate(final String username, final String password) throws LoginException {
		// Create the proxy for the Bird Authentication Service
        URL url = AbstractLoginModule.class.getResource("/META-INF/wsdl/Authentication.wsdl");
        BirdAuthenticationService client = new BirdAuthenticationService(url);
        BirdAuthentication proxy = client.getBirdAuthenticationPort();
        
        debug("Launching endpoint authentication");
        
        // Set the correct endpoint as it was passed from the JAAS config
        ((BindingProvider)proxy).getRequestContext().put
			(BindingProvider.ENDPOINT_ADDRESS_PROPERTY, this.birdLoginServiceUrl);
        
        debug("WS Login Provider set to: " + this.birdLoginServiceUrl);
        
        is.hugvit.bird.jaas.security.client.BirdUserPrincipal bp 
        	= proxy.authenticate(username, password);
        
        if (bp == null) {
        	logger.info("Authentication failed. User: " + username);
        	throw new LoginException("Authentication failed. User: " + username);
        }
        
        if (bp.getRoles() == null || bp.getRoles().size()==0) {
        	throw new LoginException("Authentication failed: No roles are assigned to user");
        }
        
        return bp;
	}



}
