package is.hugvit.bird.jaas.handlers;

import is.hugvit.bird.jaas.callback.CertificateSubjectCallback;

import java.io.IOException;
import java.util.StringTokenizer;

import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;

public class CertificateSubjectCallbackHandler implements CallbackHandler {

	private String certificateSubject;
	
	public CertificateSubjectCallbackHandler(String certificateSubject) {
		this.certificateSubject = certificateSubject;
	}
	
	public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
		
		if (callbacks[0] instanceof CertificateSubjectCallback) {
			CertificateSubjectCallback cc = (CertificateSubjectCallback)callbacks[0];
			handleCallback(cc);	
			
		} else {
			throw new UnsupportedCallbackException(callbacks[0], "Unrecognized Callback");
     	}
	}
	
	private void handleCallback(CertificateSubjectCallback callback) throws IOException {
		if (this.certificateSubject != null) {
			
			StringTokenizer st = new StringTokenizer(this.certificateSubject,",");
			while (st.hasMoreElements()) {
				String token = st.nextToken().trim();
				String[] keypair = token.split("=");
				if (keypair.length == 2) {
					String key = keypair[0];
					String val = keypair[1];
					
					if ("CN".equals(key)) {
						callback.setCommonName(val);
					} else if ("SERIALNUMBER".equals(key)) {
						callback.setUserName(val);
					} else if ("OU".equals(key)) {
						callback.getOrganizationUnit().add(val);
					} else if ("C".equals(key)) {
						callback.setCountry(val);
					}
				}
			}
			
			
		} else {
			throw new IOException("No certificate Subject has been set!");
		}
	
	}

}
