package is.hugvit.bird.jaas.handlers;

import java.io.IOException;

import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

/**
 * 
 * JAAS CallbackHandler for username / password authentication
 * 
 * @author konni
 *
 */
public class BirdUsernameCallBackHandler implements CallbackHandler {

	private String user;
	private String pass;

	public BirdUsernameCallBackHandler(String user, String pass) {
	      this.user = user;
	      this.pass = pass;
	}

	public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
		for (int i = 0; i < callbacks.length; i++) {
			if (callbacks[i] instanceof NameCallback) {
				NameCallback nc = (NameCallback)callbacks[i];
				nc.setName(user);
         } else if (callbacks[i] instanceof PasswordCallback) {
            PasswordCallback pc = (PasswordCallback)callbacks[i];
            pc.setPassword(pass.toCharArray());
         } else {
            throw new UnsupportedCallbackException(callbacks[i], "Unrecognized Callback");
         }
      }
   }
}
