package is.hugvit.bird.jaas.callback;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;

public class CertificateSubjectCallback extends NameCallback implements Callback {
	
	private static final long serialVersionUID = 1L;
	
	private boolean isValid = false;
	private String commonName;
	private String country;
	private String userName;
	private List<String> organizationUnit = new ArrayList<String>();
	

	public CertificateSubjectCallback(String prompt) {
         super(prompt);
	}
	
	
	public CertificateSubjectCallback(String prompt, String defaultName) {
	     super(prompt, defaultName);
	}
	
	

	/**
	 * @return the commonName
	 */
	public String getCommonName() {
		return commonName;
	}


	/**
	 * @param commonName the commonName to set
	 */
	public void setCommonName(String commonName) {
		this.commonName = commonName;
	}


	/**
	 * @return the country
	 */
	public String getCountry() {
		return country;
	}


	/**
	 * @param country the country to set
	 */
	public void setCountry(String country) {
		this.country = country;
	}


	/**
	 * @return the userName
	 */
	public String getUserName() {
		return userName;
	}


	/**
	 * @param userName the userName to set
	 */
	public void setUserName(String userName) {
		this.userName = userName;
	}


	/**
	 * @return the organizationUnit
	 */
	public List<String> getOrganizationUnit() {
		return organizationUnit;
	}


	/**
	 * @param organizationUnit the organizationUnit to set
	 */
	public void setOrganizationUnit(List<String> organizationUnit) {
		this.organizationUnit = organizationUnit;
	}


	/**
	 * @return the isValid
	 */
	public boolean isValid() {
		return isValid;
	}
	
	/**
	 * Populate the internal valus based on the NameCallback.getName() value
	 * 
	 */
	public final void populateValues() {
	
		String certString = getName();
		if (certString != null) {
			
			StringTokenizer st = new StringTokenizer(certString,",");
			if (st.countTokens() > 0) {
			
				while (st.hasMoreElements()) {
					String token = st.nextToken().trim();
					String[] keypair = token.split("=");
					if (keypair.length == 2) {
						String key = keypair[0].trim();
						String val = keypair[1].trim();
						
						if ("CN".equals(key)) {
							setCommonName(val);
						} else if ("SERIALNUMBER".equals(key)) {
							setUserName(val);
						} else if ("OU".equals(key)) {
							getOrganizationUnit().add(val);
						} else if ("C".equals(key)) {
							setCountry(val);
						}
					}
				}
				
				if (commonName != null) {
					isValid = true;
				}
				
				if (userName == null && commonName != null) {
					userName = commonName;
				}
				
			}
		}
	}

	  /* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		String s = "";
		s+= "Common Name: "+ commonName + "\n";
		s+= "Username: "+ userName + "\n";
		s+= "Country: "+ country + "\n";
		String org = "";
		for (String o : organizationUnit) {
			org += o + " ";
		}
		s+= "Organization Unit: " + org.trim() + "\n";
		return s;
	}

	
}
