package is.hugvit.bird.jaas;

import java.security.Principal;
import java.util.List;

public interface IBirdUserPrincipal extends Principal {

	/** 
	 * Get the userId
	 * @return The userId
	 */
	public abstract String getUserId();
	
	/**
	 * Set the userid 
	 * @param id The userid
	 */
	public abstract void setUserId(String id);
	
	/**
	 * Get the fullname of the user
	 * @return The full name
	 */
	public abstract String getFullName();
	
	/**
	 * Set the fullname
	 * @param name The full name of the user
	 */
	public abstract void setFullName(String name);
	
	 /**
     * @see java.security.Principal#getName()
     */
    public abstract String getName();
    
    
    /**
     * Set the usernmae
     * @param the username
     */
    public abstract void setName(String name);
    
	
	/**
	 * Get the email
	 * @return the email
	 */
	public abstract String getEmail();
	
	/**
	 * Set the email
	 * 
	 * @param email The email
	 */
	public abstract void setEmail(String email);
	
	/**
	 * Set the users selected  localization code
	 * 
	 * @param locale The localization code
	 */
	public abstract void setLocale(String locale);
	
	/**
	 * Get the users localization if any has been set
	 * 
	 * @return The localization code for the user
	 */
	public abstract String getLocale();
	
	/**
	 * Get the roles assigned to the user
	 * @return the role list
	 */
	public abstract List getRoles();
	
	/**
	 * Set the roles assigned to the user
	 * @param roles The role list
	 */
	public abstract void setRoles(List roles);
	
	
	/**
	 * @return Was the user authenticated using Client Certificate ?
	 */
	public abstract boolean isCertificateAuthentication();
	
	/**
	 * @param isCertificateAuthentication Mark user authenticated using Client Certificate
	 */
	public abstract void setCertificateAuthentication(final boolean isCertificateAuthentication);
	
	/**
	 * Was the user authenticated using LDAP Directory Server
	 * 
	 * @return the if authenticated using LDAP
	 */
	public abstract boolean isDirectoryAuthentication();
	
	/**
	 * Set the current authentication scheme as Directory Authentication
	 * 
	 * @param isDirectoryAuthentication
	 */
	public abstract void setDirectoryAuthentication(final boolean isDirectoryAuthentication);
	
	
	public abstract String toString();

    public abstract boolean equals(Object obj);

    public abstract int hashCode();

	
	
}
