package is.hugvit.bird.jaas;

import java.security.Principal;

/*
 * This interface represents role principal in BIRD project.
*  JAAS has a limitation on user roles. It cannot store roles. Tomcat uses
*  the following workaround: stores the first principal as a user principal
*  and all others as role principals.
*/
 
public interface IBirdRolePrincipal extends Principal {

	 /**
     * @see java.security.Principal#getName()
     */
    public abstract String getName();

    /**
     * @see java.security.Principal#toString()
     */
    public abstract String toString();

    /**
     * @see java.security.Principal#equals(java.lang.Object)
     */
    public abstract boolean equals(Object obj);

    /**
     * @see java.security.Principal#hashCode()
     */
    public abstract int hashCode();
	
}
