var BirdCommonPage = {

    strConfirm: 'Are you sure you want to delete "{0}"?',

    initialize: function () {
        window.dhx_globalImgPath='files';
        this._framesBreakout();
        this._focusFirst();
    },

    _focusFirst : function() {
        if (document.location.href.indexOf('#') > 0) {
            return;
        }
        var e = $A(document.getElementsByTagName('*')).find(function(e) {
            return (e.tagName.toUpperCase() == 'INPUT' && (e.type == 'text' || e.type == 'password'))
                || e.tagName.toUpperCase() == 'TEXTAREA' || e.tagName.toUpperCase() == 'SELECT';
        });
        if (e) try{e.focus()} catch (ex){};
    },

    _framesBreakout: function() {
        try {
            var i = top.location.href == document.location.href;
            var o = document.location.href.toQueryParams();
            var d = o.debug;
            if (!(d == '1' || d == 'true')) {
                var u = document.location.href;
                if (i) {top.location.href='bird_index.html?frame='+u;}
            }
        } catch (ex) {}
    },

    IsDigit: function(event) {
        var c = event.keyCode? event.keyCode : event.charCode;
        return (c >= 48 && c <= 57);
    },

    confirmDelete: function(name, page, id) {
        var s = this.strConfirm.replace('{0}' ,name);
        if (confirm(s))   {
            location.href = page+'?delete&id='+id;
        }
    },

    doDelete: function(id) {
        var msg = BirdCommonPage.strConfirm;
        var url = window.location.pathname;
        url += '?delete=true&id='+id;
        if (confirm(msg)) {
            location.href = url;
        }
    }

}

var BirdMenuPage = {

    xmlList : 'bird_menu.xml',
    tree : null,
    menu : null,

    initialize: function () {

        this.tree = new dhtmlXTreeObject('menu-tree', '100%', '100%', 0);
        this.menu = new dhtmlXMenuObject(null, 'standard');

        this.menu.setImagePath('../files/bird/gas/');
        this.menu.setIconsPath('../files/bird/gas/');
        this.menu.renderAsContextMenu();
        this.menu.attachEvent('onClick', this.menuClick.bind(this));
        this.menu.loadXML('../files/bird/treemenu/treemenu.xml');

        this.tree.setImagePath('../files/bird/gas/');
        this.tree.loadXML(this.xmlList);
        this.tree.attachEvent('onClick',this.treeClick.bind(this));
        this.tree.enableContextMenu(this.menu);

        this.tree.attachEvent('onBeforeContextMenu', function(itemId) {
            var type = BirdMenuPage.tree.getUserData(itemId, 'type');
            if (type != null && type == 'folder') {
                return true;
            } else {
                return false;
            }
        })
    },

    menuClick: function(menuitemId,type) {
        var id = this.tree.contextID;
        var url = this.tree.getUserData(id,"folder_id");
        var win = window.top.body;
        if (menuitemId == 'bird_edit') {
            win.location.href = 'bird_folder.html?edit&id='+url;
        } else if (menuitemId == 'bird_new') {
            win.location.href = 'bird_folder.html?create&parent='+url;
        } else if (menuitemId == 'bird_delete') {
            if (confirm('Delete folder ?')) {
                win.location.href = 'bird_folder.html?delete&id='+url;
            }
        }

        return true;
    },

    treeClick: function(id) {
        var url = this.tree.getUserData(id, 'url');
        if (url != null) {
            var w = window.top.body;
            w.location.href=url;
        }
    }
}

var BirdPageList = {

    strSelectPageType: 'Select page type',
    pageTypeCount : 0,
    folderId : '',
    isReload: false,
    pageTitles: [],

    initialize: function () {
        if (this.isReload) {
            parent.menu.location.href = 'bird_menu.html?id='+this.folderId;
        }

    },

    openPageTypeDialog: function() {
        if (this.pageTypeCount > 0) {
            jQuery("#pagetypes").modal('show').css({
                'margin-left': function () {
                   return -(jQuery(this).width() / 2);
                 }
            });
        } else {
            this.createPage('');
        }
    },

    createPage: function(pagetype) {
        window.location.href = 'bird_page.html?create&folder='+this.folderId+'&pagetype='+pagetype;
    }


}

var BirdFilePage = {

    fileChange: function() {
        var form = document.forms[0];
        var s = this.convertToFilename(form.file.value).toLowerCase();

        var pos = s.lastIndexOf("\\");
        if (pos >= 0) {
            s = s.substring(pos+1);
        }
        pos = s.lastIndexOf("/");
        if (pos >= 0) {
            s = s.substring(pos+1);
        }
        if (form.filename.value == '') {
            form.filename.value = s;
        }
        if (form.name.value == '') {
            pos = s.lastIndexOf('.');
            if (pos >=0 ) {
                s = s.substring(0,pos);
            }
            form.name.value = s;
        }
    },

    selectShowHide: function(obj) {
        var value = obj.options[obj.selectedIndex].value;
        var obj1 = $('alt');
        var obj2 = $('file');
        var obj3 = $('code');
        var obj4 = $('filename');
        var obj5 = $('encoding');
        if (value == "CODE") {
            obj1.style.display = 'none';
            obj2.style.display = 'none';
            obj3.style.display = 'block';
            obj4.style.display = 'block';
            obj5.style.display = 'block';
        } else if (value == "IMAGE") {
            obj1.style.display = 'block';
            obj2.style.display = 'block';
            obj3.style.display = 'none';
            obj4.style.display = 'block';
            obj5.style.display = 'none';
        } else if (value == "ATTACHMENT") {
            obj1.style.display = 'block';
            obj2.style.display = 'block';
            obj3.style.display = 'none';
            obj4.style.display = 'block';
            obj5.style.display = 'none';
        }
    },

    zoomin: function() {
        var field = $('idcode');
        field.cols = 50;
        field.rows = 5;
        var e1 = $('idzoomin');
        var e2 = $('idzoomout');
        e1.style.display='none';
        e2.style.display='block';
    },

    zoomout: function() {
        var field = $('idcode');
        field.cols = 90;
        field.rows = 20;
        var e1 = $('idzoomin');
        var e2 = $('idzoomout');
        e1.style.display='block';
        e2.style.display='none';
    },

    doSubmit: function() {
        this.fileChange();
        var form = document.forms[0];
        form.submit();
    },

    convertToFilename: function(s) {
        var a1 = new Array("á","é","ð","í","ó","ú","ý","þ","æ","ö","Á","É","Ð","Í","Ó","Ú","Ý","Þ","Æ","Ö"," ","'","\"");
        var a2 = new Array("a","e","d","i","o","u","y","th","ae","o","A","E","D","I","O","U","Y","TH","AE","O","","","");
        var t = "";
        for (var i=0;i<s.length;i++)  {
            var c = s.charAt(i);
            for (var j=0;j<a1.length;j++)  {
                if (c==a1[j])  {
                    c = a2[j];
                }
            }
            t = t + c;
        }
        return t;
    }

}

var BirdEditPage = {

    calendarPage: null,
    calendarStart: null,
    calendarEnd: null,
    dateFormat: '%m/%d/%y',
    isLoaded: false,
    locale: 'en',
    
    initialize: function(locale) {

    	if (locale != '') {
    		this.locale = locale;
    	}
    	
        // Initialize date fields
        this.calendarPage  = new dhtmlxCalendarObject({input: 'pagedate'});
        this.calendarStart = new dhtmlxCalendarObject({input: 'startdate'});
        this.calendarEnd   = new dhtmlxCalendarObject({input: 'enddate'});

        this.calendarPage.setDateFormat(this.dateFormat);
        this.calendarStart.setDateFormat(this.dateFormat);
        this.calendarEnd.setDateFormat(this.dateFormat);

        this.initEditor();
        Event.observe(window, "resize", BirdEditPage.resizeEditor);

        this.isLoaded = true;

    },

    pagePart: function(layer) {
        var list = ['editor','preview','settings'];
        list.each(function(item) {
            if (item == layer) {
                $(item).show();
            } else {
                $(item).hide();
            }
        });
    },

    doSave: function(redirect) {
        if (!BirdEditPage.isLoaded){
            alert(msg_page_loading);
            return;
        }
        if ($('pagetitle').value.strip() == '') {
            this.pagePart('settings');
            $('pagetitle').focus();
            alert(msg_title_missing);
            return;
        }
        $('pageform').submit();
    },

    initEditor: function() {
    	
    	var options = {
            selector: "textarea.editor",
            entity_encoding : "raw",
            width : "100%",
            height:  this.getOptimalEditorHeight(),
            removed_menuitems: 'newdocument',
            theme: "modern",
            //toolbar_items_size: 'small',


            plugins: [
                "advlist autolink lists link image charmap print preview hr anchor pagebreak",
                "searchreplace wordcount visualblocks visualchars code fullscreen",
                "insertdatetime media nonbreaking save table contextmenu directionality",
                "emoticons paste textcolor"
            ],

            image_list: "tiny_list.js?js=images&format=json",
            link_list:  "tiny_list.js?js=links&format=json",


            toolbar1: "insertfile undo redo | styleselect formatselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent",
            toolbar2: "link image preview media | forecolor backcolor emoticons | print fullscreen",
            image_advtab: true
        };
    	
    	if (this.locale != '' && this.locale != 'en') {
    		options.language = this.locale;
    	}
    	
        tinymce.init(options);
    },

    resizeEditor: function() {
        var resizeHeight = BirdEditPage.getOptimalEditorHeight() + "px";
        var textElement = tinymce.DOM.get('body_ifr');
        tinymce.DOM.setStyle(textElement, 'height', resizeHeight);
    },

    editorFullScreen: function() {
        tinyMCE.get('body').execCommand('mceFullScreen');
    },

    editorCode: function () {
        tinyMCE.get('body').execCommand('mceCodeEditor');
    },

    getOptimalEditorHeight: function() {
        var t = 300;
        var h = window.innerHeight;
        if (h > t) {
            return (h-t);
        } else {
            return h;
        }

    }



}

var BirdLicence = {

    serverId: null,
    platform:  'Self Service',
    version: null,

    requestLicence: function() {
        var url = 'http://licence.gopro.net/web/licenceAuthentication.html?';
        var params = 'GoProPlatform='+this.platform+'&Version='+this.version+'&ServerID='+this.serverId;
        window.open(url+params);
    },

    displayLicense: function() {
        setTimeout(function() {
            window.location = 'bird_licence.html';
        }, 5000)
    }

}