/*
 * Decompiled with CFR 0.152.
 */
package is.hugvit.xml;

import is.hugvit.xml.Attribute;
import is.hugvit.xml.HtmlConverter;
import is.hugvit.xml.MarkupParser;
import is.hugvit.xml.NamedNodeMapImpl;
import is.hugvit.xml.NodeEx;
import is.hugvit.xml.ParserConfig;
import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.TypeInfo;
import org.w3c.dom.UserDataHandler;

final class NodeTag
extends NodeEx
implements Element {
    private String tag;
    private Hashtable attributes;
    private Vector map;

    protected NodeTag(NodeEx parent, String tag, ParserConfig config) {
        this.parent = parent;
        this.tag = tag;
        this.map = ((HtmlConverter)config).map;
    }

    @Override
    public NamedNodeMap getAttributes() {
        return new NamedNodeMapImpl(this.attributes);
    }

    @Override
    public Object setUserData(String key, Object data, UserDataHandler handler) {
        return null;
    }

    @Override
    public final void setAttribute(String name, String value) {
        this.setAttribute(name, value, '\"');
    }

    protected final void setAttribute(String name, String value, char stringchar) {
        if (this.attributes == null) {
            this.attributes = new Hashtable();
        }
        this.attributes.put(name, new Attribute(this, name, stringchar, value, this.map));
    }

    @Override
    public final String getTagName() {
        return this.tag;
    }

    @Override
    public String getNodeName() {
        return this.tag;
    }

    @Override
    public final void write(Writer out, ParserConfig config) throws IOException {
        Enumeration<Object> e;
        if (config.getDropEmptyParas() && this.tag.equals("p") && this.nodes.size() == 0) {
            return;
        }
        char tag_start = '<';
        char tag_end = '>';
        if (config.getWriteAlternateXSL() && this.tag.startsWith("xsl:")) {
            tag_start = '[';
            tag_end = ']';
        }
        if (!config.getTextOnly()) {
            out.write(tag_start);
            out.write(this.tag);
            if (this.attributes != null) {
                e = this.attributes.elements();
                while (e.hasMoreElements()) {
                    Attribute a = (Attribute)e.nextElement();
                    out.write(" ");
                    a.write(out);
                }
            }
        }
        if (this.nodes.size() == 0) {
            if (!config.getTextOnly()) {
                if (MarkupParser.isBlockElement(this.tag)) {
                    out.write(tag_end + "" + tag_start + "/" + this.tag + tag_end);
                } else {
                    out.write("/" + tag_end);
                }
            }
        } else {
            if (!config.getTextOnly()) {
                out.write(tag_end);
            }
            if (!config.getTextOnly() || !this.tag.equals("script")) {
                e = this.nodes.elements();
                while (e.hasMoreElements()) {
                    NodeEx n = (NodeEx)e.nextElement();
                    n.write(out, config);
                }
            }
            if (!config.getTextOnly()) {
                out.write(tag_start + "/");
                out.write(this.tag);
                out.write(tag_end);
            }
        }
    }

    @Override
    public final void writeTree(Writer out, int space) throws IOException {
        if (this.nodes.size() == 0) {
            out.write(NodeTag.getSpace(space) + "<" + this.tag + "/>\r\n");
        } else {
            out.write(NodeTag.getSpace(space) + "<" + this.tag + ">\r\n");
            Enumeration e = this.nodes.elements();
            while (e.hasMoreElements()) {
                NodeEx n = (NodeEx)e.nextElement();
                n.writeTree(out, space + 2);
            }
            out.write(NodeTag.getSpace(space) + "</" + this.tag + ">\r\n");
        }
    }

    @Override
    public final String getAttribute(String name) {
        Attribute a;
        if (this.attributes != null && (a = (Attribute)this.attributes.get(name)) != null) {
            return a.getValue();
        }
        return "";
    }

    @Override
    public final Attr getAttributeNode(String name) {
        return null;
    }

    @Override
    public final void removeAttribute(String name) {
    }

    @Override
    public final Attr removeAttributeNode(Attr oldAttr) {
        return null;
    }

    @Override
    public final Attr setAttributeNode(Attr newAttr) {
        return null;
    }

    @Override
    public final short getNodeType() {
        return 1;
    }

    @Override
    public final void removeAttributeNS(String namespaceURI, String localName) {
    }

    @Override
    public final void setAttributeNS(String namespaceURI, String qualifiedName, String value) {
    }

    @Override
    public final Attr getAttributeNodeNS(String namespaceURI, String localName) {
        return null;
    }

    @Override
    public final boolean hasAttributeNS(String namespaceURI, String localName) {
        return false;
    }

    @Override
    public TypeInfo getSchemaTypeInfo() {
        return null;
    }

    @Override
    public final String getAttributeNS(String namespaceURI, String localName) {
        return null;
    }

    @Override
    public final boolean hasAttribute(String attribute) {
        if (this.attributes != null) {
            return this.attributes.get(attribute) != null;
        }
        return false;
    }

    @Override
    public final Attr setAttributeNodeNS(Attr newAttr) {
        return null;
    }

    public String toString() {
        return "<" + this.tag + ">";
    }

    @Override
    public final void setIdAttribute(String name, boolean isId) throws DOMException {
    }

    @Override
    public final void setIdAttributeNode(Attr idAttr, boolean isId) throws DOMException {
    }

    @Override
    public final void setIdAttributeNS(String namespaceURI, String localName, boolean isId) throws DOMException {
    }
}

